/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class PatrolGoal
extends Goal {
    private final BaseCombatEntity mob;
    private final double speed;
    private int currentIndex = 0;
    private boolean reverse = false;
    private int stayTicks = 0;
    private final int maxStayTicks;
    private Path currentPath;
    private BlockPos targetPos;
    private boolean arrived;

    public PatrolGoal(BaseCombatEntity mob, double speed, int maxStayTicks) {
        this.mob = mob;
        this.speed = speed;
        this.maxStayTicks = maxStayTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.commandHold()) {
            return false;
        }
        return !this.mob.getPatrolPoints().isEmpty() && !this.mob.m_20159_();
    }

    public boolean m_8045_() {
        if (this.mob.commandHold()) {
            return false;
        }
        return !this.mob.getPatrolPoints().isEmpty();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8056_() {
        this.arrived = false;
    }

    public void m_8037_() {
        if (this.mob.commandHold()) {
            return;
        }
        if (this.currentIndex > this.mob.getPatrolPoints().size() - 1) {
            this.currentIndex = this.mob.getPatrolPoints().size() - 1;
        } else if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        if (this.mob.getPatrolPoints().get(this.currentIndex) != null) {
            this.setTargetPos(this.mob.getPatrolPoints().get(this.currentIndex));
        }
        if (this.targetPos != null) {
            BlockPos currentPos = new BlockPos((int)Math.floor(this.mob.m_20185_()), this.targetPos.m_123342_(), (int)Math.floor(this.mob.m_20189_()));
            if (currentPos.m_123314_((Vec3i)this.targetPos, this.mob.getArrivalThreshold())) {
                this.arrived = true;
            } else if (!this.arrived) {
                this.moveToCurrentPoint();
            }
            if (this.arrived) {
                if (this.stayTicks < this.maxStayTicks) {
                    ++this.stayTicks;
                } else {
                    this.stayTicks = 0;
                    this.moveToNextPoint();
                    this.arrived = false;
                }
            }
        }
    }

    private void moveToCurrentPoint() {
        double deltaZ;
        double deltaX;
        double distance;
        if (this.currentPath == null || this.currentPath.m_77392_() || !this.mob.m_21573_().m_26572_()) {
            this.currentPath = this.mob.m_21573_().m_148218_(this.targetPos, 0, 16);
        }
        this.mob.m_21573_().m_26536_(this.currentPath, this.speed);
        if (!this.mob.m_21573_().m_26572_() && (distance = Math.sqrt((deltaX = (double)this.targetPos.m_123341_() - this.mob.m_20185_()) * deltaX + (deltaZ = (double)this.targetPos.m_123343_() - this.mob.m_20189_()) * deltaZ)) < 10.0 * this.mob.getArrivalThreshold() && distance > 0.01) {
            double smallMoveSpeed = 0.05;
            this.mob.m_20334_(deltaX / distance * smallMoveSpeed, this.mob.m_20184_().f_82480_, deltaZ / distance * smallMoveSpeed);
        }
    }

    private void moveToNextPoint() {
        List<BlockPos> patrolPoints = this.mob.getPatrolPoints();
        if (this.reverse) {
            --this.currentIndex;
            if (this.currentIndex <= 0) {
                this.reverse = false;
            }
        } else {
            ++this.currentIndex;
            if (this.currentIndex >= patrolPoints.size() - 1) {
                if (patrolPoints.get(0).equals((Object)patrolPoints.get(patrolPoints.size() - 1))) {
                    this.currentIndex = 0;
                } else {
                    this.reverse = true;
                }
            }
        }
        this.moveToCurrentPoint();
    }

    public void setTargetPos(BlockPos targetPos) {
        BlockState blockState = ((EntityAccessor)((Object)this.mob)).getLevel().m_8055_(targetPos);
        this.targetPos = !blockState.m_60804_((BlockGetter)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.m_60795_() ? targetPos : targetPos.m_7494_();
    }
}

