/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class SkyExposedTargetGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private final BaseCombatEntity entity;

    public SkyExposedTargetGoal(BaseCombatEntity entity, Class<LivingEntity> targetClass, int randomInterval, boolean mustSee, boolean mustReach, @Nullable Predicate<LivingEntity> targetPredicate) {
        super((Mob)entity, targetClass, randomInterval, mustSee, mustReach, targetPredicate);
        this.entity = entity;
        if (!(entity instanceof RangedAttackMob)) {
            throw new IllegalArgumentException("RangedAttackerTargetGoal \u5fc5\u987b\u7528\u4e8e\u5b9e\u73b0 RangedAttackMob \u63a5\u53e3\u7684\u5b9e\u4f53");
        }
    }

    protected void m_26073_() {
        LivingEntity skyExposedTarget;
        super.m_26073_();
        if (this.f_26050_ == null && this.entity.m_9236_().m_45527_(this.entity.m_20183_()) && (skyExposedTarget = this.findNearestTarget(this::isValidSkyExposedTarget)) != null) {
            this.f_26050_ = skyExposedTarget;
        }
    }

    private LivingEntity findNearestTarget(Predicate<LivingEntity> predicate) {
        double attackReach = this.entity.getAttackReach();
        double attackReachSq = attackReach * attackReach;
        AABB searchArea = this.f_26135_.m_20191_().m_82400_(attackReach);
        return this.f_26135_.m_9236_().m_6443_(LivingEntity.class, searchArea, predicate).stream().filter(e -> this.f_26135_.m_20280_((Entity)e) <= attackReachSq).min(Comparator.comparingDouble(arg_0 -> ((Mob)this.f_26135_).m_20280_(arg_0))).orElse(null);
    }

    private boolean isValidSkyExposedTarget(LivingEntity entity) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.isEntitySkyExposed(entity) && this.entity.isValidTarget(entity);
    }

    private boolean isEntitySkyExposed(LivingEntity entity) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                if (entity.m_9236_().m_45527_(entity.m_20183_().m_7918_(xOffset, 0, zOffset))) continue;
                return false;
            }
        }
        return true;
    }
}

