/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.entity.utils.Rideable;

public class TargetAttackGoal
extends Goal
implements CommandedGoal {
    protected BaseCombatEntity mob;
    protected LivingEntity target;
    private final double speedTowardsTarget;
    private final float maxAttackDistance;
    private final LivingEntity attackTarget;
    private Path currentPath;
    private boolean pathGenerated = false;

    public TargetAttackGoal(BaseCombatEntity mob, double speed, float maxDistance, LivingEntity attackTarget) {
        this.mob = mob;
        this.speedTowardsTarget = speed;
        this.maxAttackDistance = maxDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attackTarget = attackTarget;
    }

    public boolean m_8036_() {
        this.target = this.attackTarget;
        return this.target != null && this.target.m_6084_();
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (!this.mob.commandHold()) {
            this.mob.setCommandHold(false);
        }
        this.mob.setHywTarget(this.attackTarget);
        this.mob.setForceAttackTarget(true);
        if (this.mob instanceof Rideable && !this.mob.m_20197_().isEmpty()) {
            for (Entity passenger : this.mob.m_20197_()) {
                if (!(passenger instanceof BaseCombatEntity)) continue;
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal((BaseCombatEntity)passenger, 1.0, ((BaseCombatEntity)passenger).getAttackReach(), this.target);
                ((BaseCombatEntity)passenger).addCustomGoal(1, targetAttackGoal);
            }
        }
        this.createPathingTask(this.mob);
    }

    public void m_8041_() {
        this.mob.setHywTarget(null);
        this.mob.setHomePosition(this.mob.m_20183_());
        this.mob.setForceAttackTarget(false);
        this.executeNext();
    }

    public void m_8037_() {
        this.target = this.attackTarget;
        this.mob.setHywTarget(this.attackTarget);
        if (!(this.mob.getWithinAttackRange() || this.mob.commandHold() || this.mob.isHolding())) {
            this.pursueTarget();
        }
    }

    private void pursueTarget() {
        if (this.mob.m_20159_()) {
            return;
        }
        if (this.pathGenerated) {
            this.mob.m_21573_().m_5624_((Entity)this.mob.getHywTarget(), 1.0);
        }
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    private void createPathingTask(BaseCombatEntity mob) {
        Consumer<Path> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, this.attackTarget.m_20183_(), pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.getOwnerUUID());
        manager.addTask(task);
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        this.mob = newEntity;
    }
}

