/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.FormMoveGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveToBlockGoal;

public class FormationManager {
    private static Map<UUID, FormationStatus> formations = new ConcurrentHashMap<UUID, FormationStatus>();
    private static BlockPos lastPos;

    public static UUID createNewFormation(List<BaseCombatEntity> entities) {
        UUID formationId = UUID.randomUUID();
        FormationStatus status = new FormationStatus(entities);
        status.setFormationSize(entities.size());
        formations.put(formationId, status);
        return formationId;
    }

    public static FormationStatus getFormationStatus(UUID formationId) {
        if (formationId == null) {
            return null;
        }
        return formations.get(formationId);
    }

    public static void clearFormation(UUID formationId) {
        formations.remove(formationId);
    }

    public static boolean targetReachAll(UUID formationId) {
        return FormationManager.getFormationStatus(formationId).isTargetReached();
    }

    public static void clearTargetReached(UUID formationId) {
        FormationManager.getFormationStatus(formationId).clearTargetReached();
    }

    public static void setFormationSize(UUID formationId, int size) {
        FormationManager.getFormationStatus(formationId).setFormationSize(size);
    }

    public static void markEntityReady(UUID formationId, BaseCombatEntity entity) {
        FormationManager.getFormationStatus(formationId).markEntityReady(entity);
    }

    public static boolean FormationReadyAll(UUID formationId) {
        return FormationManager.getFormationStatus(formationId).isFormationCompleted();
    }

    public static boolean shouldTeleport(UUID formationId) {
        return (double)FormationManager.getFormationStatus((UUID)formationId).formationReadyEntities.size() >= 0.75 * (double)FormationManager.getFormationStatus((UUID)formationId).formationSize;
    }

    public static void move(List<BaseCombatEntity> entities, BlockPos targetPos, int priority, boolean queueMode) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        if (queueMode) {
            for (int i = 0; i < entities.size(); ++i) {
                entities.get(i).setQueueMode(true);
            }
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        FormationManager.moveEntitiesTo(priority, entities, targetPos, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            double homeReturnRadius = Double.max(entities.size(), entities.get(i).getDefaultHomeReturnRadius());
            entities.get(i).setHomeReturnRadius(homeReturnRadius);
        }
        lastPos = targetPos;
    }

    public static void hold(List<BaseCombatEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setCommandHold(true);
            entities.get(i).setHomePosition(entities.get(i).m_20183_());
        }
    }

    public static void formMove(List<BaseCombatEntity> entities, BlockPos targetPos, int priority, boolean queueMode, String formationType) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        BlockPos startPos = FormationManager.calculateFormationCenter(entities);
        if (lastPos == null) {
            lastPos = startPos;
        }
        if (queueMode) {
            for (int i = 0; i < entities.size(); ++i) {
                entities.get(i).setQueueMode(true);
            }
            startPos = lastPos;
        }
        float yaw = FormationManager.getYawFromPositions(startPos, targetPos);
        Vec3 formDirection = FormationManager.calculateDirectionVector(startPos, targetPos);
        FormationManager.getFormationStatus(formationId).setFormDirection(formDirection);
        double formDistance = Math.sqrt(startPos.m_123331_((Vec3i)targetPos));
        FormationManager.getFormationStatus(formationId).setFormDistance(formDistance);
        List<BlockPos> positions = FormationManager.getFormationPositions(startPos, entities.size(), entities.get(0).m_9236_(), formationType, yaw);
        FormationManager.moveEntitiesToFormation(entities, positions, priority, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            entities.get(i).setHomeReturnRadius(entities.get(i).getDefaultHomeReturnRadius());
        }
        lastPos = targetPos;
    }

    public static void commandStaffFormMove(BlockPos targetPos, int priority, List<BaseCombatEntity> entities, String formationType) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        BlockPos startPos = FormationManager.calculateFormationCenter(entities);
        float yaw = FormationManager.getYawFromPositions(startPos, targetPos);
        Vec3 formDirection = FormationManager.calculateDirectionVector(startPos, targetPos);
        FormationManager.getFormationStatus(formationId).setFormDirection(formDirection);
        double formDistance = Math.sqrt(startPos.m_123331_((Vec3i)targetPos));
        FormationManager.getFormationStatus(formationId).setFormDistance(formDistance);
        List<BlockPos> positions = FormationManager.getFormationPositions(startPos, entities.size(), entities.get(0).m_9236_(), formationType, yaw);
        FormationManager.moveEntitiesToFormation(entities, positions, priority, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            entities.get(i).setHomeReturnRadius(entities.get(i).getDefaultHomeReturnRadius());
        }
    }

    public static Vec3 calculateDirectionVector(BlockPos startPos, BlockPos targetPos) {
        double dx = targetPos.m_123341_() - startPos.m_123341_();
        double dz = targetPos.m_123343_() - startPos.m_123343_();
        Vec3 direction = new Vec3(dx, 0.0, dz);
        return direction.m_82541_();
    }

    public static BlockPos calculateFormationCenter(List<BaseCombatEntity> entities) {
        if (entities.isEmpty()) {
            return BlockPos.f_121853_;
        }
        Vec3 sumPos = Vec3.f_82478_;
        for (BaseCombatEntity entity : entities) {
            sumPos = sumPos.m_82520_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
        Vec3 averagePos = sumPos.m_82490_(1.0 / (double)entities.size());
        return new BlockPos((int)Math.floor(averagePos.m_7096_()), (int)Math.floor(averagePos.m_7098_()), (int)Math.floor(averagePos.m_7094_()));
    }

    public static float getYawFromPositions(BlockPos currentCenterPos, BlockPos targetPos) {
        double deltaX = targetPos.m_123341_() - currentCenterPos.m_123341_();
        double deltaZ = targetPos.m_123343_() - currentCenterPos.m_123343_();
        double yawRadians = Math.atan2(deltaZ, deltaX);
        double yawDegrees = Math.toDegrees(yawRadians);
        double minecraftYaw = (yawDegrees - 90.0) % 360.0;
        if (minecraftYaw < 0.0) {
            minecraftYaw += 360.0;
        }
        minecraftYaw = (minecraftYaw % 360.0 + 360.0) % 360.0;
        return (float)minecraftYaw;
    }

    public static List<BlockPos> getFormationPositions(BlockPos center, int numUnits, Level level, String formationType, float yaw) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        switch (formationType) {
            case "tight": {
                int spacing = 2;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "tight");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
                break;
            }
            case "line": {
                int spacing = 2;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "line");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
                break;
            }
            case "circle": {
                int spacing = 2;
                int emptyRings = FormationManager.computeEmptyRings(numUnits, 0.3);
                positions.addAll(FormationManager.generateSmartHollowCircularFormation(center, numUnits, level, spacing, emptyRings, yaw));
                Collections.reverse(positions);
                break;
            }
            case "wedge": {
                int lateralSpacing = 2;
                int depthSpacing = 4;
                positions.addAll(FormationManager.generateWedgeFormation(center, numUnits, level, lateralSpacing, depthSpacing, yaw));
                break;
            }
            default: {
                int spacing = 4;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "loose");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
            }
        }
        return positions;
    }

    private static List<BlockPos> generateRectangularFormation(BlockPos center, int numUnits, Level level, int spacing, float yaw, int formationHeight, int formationWidth) {
        ArrayList<BlockPos> generatedPositions = new ArrayList<BlockPos>();
        if (numUnits <= 0) {
            return generatedPositions;
        }
        BlockPos start = center.m_7918_(-(formationWidth / 2 * spacing), 0, -(formationHeight / 2 * spacing));
        int counter = 0;
        for (int i = formationHeight - 1; i >= 0; --i) {
            for (int j = formationWidth - 1; j >= 0 && counter < numUnits; ++counter, --j) {
                BlockPos pos = start.m_7918_(j * spacing, 0, i * spacing);
                BlockPos rotatedPos = FormationManager.rotatePosition(center, pos, yaw);
                BlockPos adjustedPos = FormationManager.adjustYCoordinate(rotatedPos, level, 10);
                generatedPositions.add(adjustedPos);
            }
            if (counter >= numUnits) break;
        }
        return generatedPositions;
    }

    public static int[] calculateRectangularDimensions(int numUnits, String formationType) {
        int width;
        int height;
        if (numUnits <= 0) {
            return new int[]{0, 0};
        }
        switch (formationType) {
            case "line": {
                height = (int)Math.ceil(Math.sqrt((double)numUnits / 10.0));
                if (height == 0) {
                    height = 1;
                }
                width = (int)Math.ceil((double)numUnits / (double)height);
                break;
            }
            default: {
                height = (int)Math.ceil(Math.sqrt((double)numUnits * 3.0 / 5.0));
                if (height == 0) {
                    height = 1;
                }
                if ((width = (int)Math.ceil((double)numUnits / (double)height)) >= height || numUnits <= 1) break;
                int temp = height;
                height = width;
                width = temp;
            }
        }
        if (height * width < numUnits) {
            if (width >= height) {
                width = (int)Math.ceil((double)numUnits / (double)height);
            } else {
                height = (int)Math.ceil((double)numUnits / (double)width);
            }
        }
        if (numUnits == 1) {
            height = 1;
            width = 1;
        }
        return new int[]{height, width};
    }

    private static int computeEmptyRings(int numUnits, double ratio) {
        if (numUnits <= 3) {
            return 0;
        }
        int unitsPlaced = 0;
        int ring = 0;
        while (unitsPlaced < numUnits) {
            int capacity = (int)Math.floor(Math.PI * 2 * (double)(ring + 1));
            unitsPlaced += capacity;
            ++ring;
        }
        int totalRings = ring;
        int emptyRings = (int)Math.ceil((double)totalRings * ratio);
        return Math.max(1, emptyRings);
    }

    private static List<BlockPos> generateCircularFormation(BlockPos center, int numUnits, Level level, int spacing, float yaw) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        if (numUnits == 1) {
            positions.add(FormationManager.adjustYCoordinate(center, level, 10));
            return positions;
        }
        double yawRad = Math.toRadians(yaw);
        int unitsRemaining = numUnits;
        int ringIndex = 0;
        while (unitsRemaining > 0) {
            double r = spacing * (ringIndex + 1);
            int maxInRing = (int)Math.floor(Math.PI * 2 * r / (double)spacing);
            maxInRing = Math.max(1, maxInRing);
            int unitsThisRing = Math.min(maxInRing, unitsRemaining);
            double angleStep = Math.PI * 2 / (double)unitsThisRing;
            for (int i = 0; i < unitsThisRing; ++i) {
                double theta = (double)i * angleStep + yawRad;
                int dx = (int)Math.round(r * Math.cos(theta));
                int dz = (int)Math.round(r * Math.sin(theta));
                BlockPos rawPos = center.m_7918_(dx, 0, dz);
                positions.add(FormationManager.adjustYCoordinate(rawPos, level, 10));
            }
            unitsRemaining -= unitsThisRing;
            ++ringIndex;
        }
        return positions;
    }

    private static List<BlockPos> generateSmartHollowCircularFormation(BlockPos center, int numUnits, Level level, int spacing, int emptyRings, float yaw) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        if (numUnits <= 3 || emptyRings == 0) {
            return FormationManager.generateCircularFormation(center, numUnits, level, spacing, yaw);
        }
        double yawRad = Math.toRadians(yaw);
        int unitsRemaining = numUnits;
        int ringIdx = emptyRings;
        int lastRingStart = -1;
        while (unitsRemaining > 0) {
            double r = spacing * (ringIdx + 1);
            int cap = (int)Math.floor(Math.PI * 2 * r / (double)spacing);
            if (unitsRemaining < (cap = Math.max(1, cap)) && lastRingStart < 0) {
                cap = unitsRemaining;
            }
            if (unitsRemaining < cap) {
                List<BlockPos> lastRing = positions.subList(lastRingStart, positions.size());
                int newCount = lastRing.size() + unitsRemaining;
                lastRing.clear();
                double rLast = spacing * ringIdx;
                double angleStep = Math.PI * 2 / (double)newCount;
                for (int i = 0; i < newCount; ++i) {
                    double theta = (double)i * angleStep + yawRad;
                    int dx = (int)Math.round(rLast * Math.cos(theta));
                    int dz = (int)Math.round(rLast * Math.sin(theta));
                    BlockPos raw = center.m_7918_(dx, 0, dz);
                    lastRing.add(FormationManager.adjustYCoordinate(raw, level, 10));
                }
                unitsRemaining = 0;
                break;
            }
            lastRingStart = positions.size();
            double angleStep = Math.PI * 2 / (double)cap;
            for (int i = 0; i < cap; ++i) {
                double theta = (double)i * angleStep + yawRad;
                int dx = (int)Math.round(r * Math.cos(theta));
                int dz = (int)Math.round(r * Math.sin(theta));
                BlockPos raw = center.m_7918_(dx, 0, dz);
                positions.add(FormationManager.adjustYCoordinate(raw, level, 10));
            }
            unitsRemaining -= cap;
            ++ringIdx;
        }
        return positions;
    }

    private static List<BlockPos> generateWedgeFormation(BlockPos center, int numUnits, Level level, int lateralSpacing, int depthSpacing, float yaw) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        double yawRad = Math.toRadians(yaw);
        Vec3 forward = new Vec3(Math.sin(yawRad), 0.0, -Math.cos(yawRad)).m_82541_();
        Vec3 right = new Vec3(forward.f_82481_, 0.0, -forward.f_82479_);
        ArrayList<Integer> rowSizes = new ArrayList<Integer>();
        int unitsLeft = numUnits;
        int row = 1;
        while (unitsLeft > 0) {
            int take = Math.min(row, unitsLeft);
            rowSizes.add(take);
            unitsLeft -= take;
            ++row;
        }
        int totalRows = rowSizes.size();
        double rowsAhead = (double)(totalRows - 1) / 2.0;
        Vec3 tipOffset = forward.m_82490_((double)(-depthSpacing) * rowsAhead);
        BlockPos tipPos = center.m_7918_((int)Math.round(tipOffset.f_82479_), 0, (int)Math.round(tipOffset.f_82481_));
        for (int rowIdx = 0; rowIdx < totalRows; ++rowIdx) {
            int rowCount = (Integer)rowSizes.get(rowIdx);
            Vec3 centerOffset = forward.m_82490_((double)(depthSpacing * rowIdx));
            BlockPos rowCenter = tipPos.m_7918_((int)Math.round(centerOffset.f_82479_), 0, (int)Math.round(centerOffset.f_82481_));
            int offsetStep = 0;
            for (int i = 0; i < rowCount; ++i) {
                int lateral = offsetStep * lateralSpacing;
                Vec3 sideOffset = right.m_82490_((double)lateral);
                BlockPos raw = rowCenter.m_7918_((int)Math.round(sideOffset.f_82479_), 0, (int)Math.round(sideOffset.f_82481_));
                positions.add(FormationManager.adjustYCoordinate(raw, level, 10));
                offsetStep = offsetStep <= 0 ? -offsetStep + 1 : -offsetStep;
            }
        }
        return positions;
    }

    public static BlockPos adjustYCoordinate(BlockPos pos, Level level, int maxOffset) {
        BlockPos newPos;
        int dy;
        for (dy = 0; dy <= maxOffset; ++dy) {
            newPos = pos.m_6630_(dy);
            if (!FormationManager.isGroundSuitable(newPos, level)) continue;
            return newPos;
        }
        for (dy = 1; dy <= maxOffset; ++dy) {
            newPos = pos.m_6625_(dy);
            if (!FormationManager.isGroundSuitable(newPos, level)) continue;
            return newPos;
        }
        return pos;
    }

    public static boolean isGroundSuitable(BlockPos pos, Level level) {
        BlockState blockAbove = level.m_8055_(pos);
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        boolean isAirAbove = blockAbove.m_60795_();
        boolean canStandOn = blockBelow.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
        return isAirAbove && canStandOn;
    }

    private static BlockPos rotatePosition(BlockPos center, BlockPos pos, float yaw) {
        double radians = Math.toRadians(yaw);
        int x = pos.m_123341_() - center.m_123341_();
        int z = pos.m_123343_() - center.m_123343_();
        int rotatedX = (int)Math.round((double)x * Math.cos(radians) - (double)z * Math.sin(radians));
        int rotatedZ = (int)Math.round((double)x * Math.sin(radians) + (double)z * Math.cos(radians));
        return center.m_7918_(rotatedX, 0, rotatedZ);
    }

    public static void moveEntitiesToFormation(List<BaseCombatEntity> entities, List<BlockPos> positions, int priority, UUID formationUUID) {
        if (entities.size() != positions.size()) {
            return;
        }
        entities.sort(Comparator.comparing(Entity::m_20148_));
        double minSpeed = Double.MAX_VALUE;
        for (BaseCombatEntity entity : entities) {
            double entitySpeed = Objects.requireNonNull(entity.m_21051_(Attributes.f_22279_)).m_22115_();
            if (!(entitySpeed < minSpeed)) continue;
            minSpeed = entitySpeed;
        }
        entities.sort((e1, e2) -> {
            Entity rider2;
            HywHorseEntity horse2;
            Entity rider1;
            HywHorseEntity horse1;
            int e1Key = e1 instanceof SiegeUnit ? 5 : (e1 instanceof HywHorseEntity ? ((horse1 = (HywHorseEntity)e1).m_20160_() && !horse1.m_20197_().isEmpty() ? ((rider1 = (Entity)horse1.m_20197_().get(0)) instanceof Player ? 4 : (rider1 instanceof RangedAttackMob ? 1 : 0)) : 4) : (e1 instanceof RangedAttackMob ? 1 : 0));
            int e2Key = e2 instanceof SiegeUnit ? 5 : (e2 instanceof HywHorseEntity ? ((horse2 = (HywHorseEntity)e2).m_20160_() && !horse2.m_20197_().isEmpty() ? ((rider2 = (Entity)horse2.m_20197_().get(0)) instanceof Player ? 4 : (rider2 instanceof RangedAttackMob ? 1 : 0)) : 4) : (e2 instanceof RangedAttackMob ? 1 : 0));
            return Integer.compare(e1Key, e2Key);
        });
        for (int i = 0; i < entities.size(); ++i) {
            FormationManager.formMoveEntity(entities.get(i), positions.get(i), priority, formationUUID, minSpeed);
        }
    }

    private static void moveEntitiesTo(int priority, List<BaseCombatEntity> entities, BlockPos targetPos, UUID formationUUID) {
        for (BaseCombatEntity entity : entities) {
            MoveToBlockGoal moveToBlockGoal = new MoveToBlockGoal(entity, 1.0, formationUUID);
            moveToBlockGoal.setTargetPos(targetPos);
            if (!entity.getQueueMode()) {
                entity.clearCommandedGoals();
            }
            entity.addCustomGoal(priority, moveToBlockGoal);
        }
    }

    private static void formMoveEntity(BaseCombatEntity entity, BlockPos pos, int priority, UUID formationId, double minSpeed) {
        FormMoveGoal formMoveGoal = new FormMoveGoal(entity, 1.0, formationId, minSpeed);
        formMoveGoal.setTargetPos(pos);
        entity.setHomePosition(pos);
        if (!entity.getQueueMode()) {
            entity.clearCommandedGoals();
        }
        entity.addCustomGoal(priority, formMoveGoal);
    }

    public static class FormationStatus {
        private Set<BaseCombatEntity> entities;
        private Set<BaseCombatEntity> formationReadyEntities = Collections.newSetFromMap(new ConcurrentHashMap());
        private Set<BaseCombatEntity> targetReachEntities = Collections.newSetFromMap(new ConcurrentHashMap());
        private int formationSize = 0;
        private boolean formationCompleted = false;
        private boolean targetReached = false;
        private Vec3 formDirection;
        private double formDistance;

        public FormationStatus(List<BaseCombatEntity> entities) {
            this.entities = ConcurrentHashMap.newKeySet();
            this.entities.addAll(entities);
        }

        public Set<BaseCombatEntity> getFormationReadyEntities() {
            return this.formationReadyEntities;
        }

        public Set<BaseCombatEntity> getTargetReachedEntities() {
            return this.targetReachEntities;
        }

        public void markTargetReached(BaseCombatEntity entity) {
            this.targetReachEntities.add(entity);
            this.checkTargetReached();
        }

        public boolean isTargetReached() {
            return this.targetReachEntities.size() == this.formationSize;
        }

        private void checkTargetReached() {
            if (this.targetReachEntities.size() == this.formationSize) {
                this.targetReached = true;
            }
        }

        public void clearTargetReached() {
            this.targetReachEntities.clear();
            this.targetReached = false;
        }

        public void setFormationSize(int size) {
            this.formationSize = size;
            this.formationReadyEntities.clear();
            this.formationCompleted = false;
        }

        public void removeEntityFromFormation(BaseCombatEntity entity) {
            this.entities.remove((Object)entity);
            --this.formationSize;
        }

        public void markEntityReady(BaseCombatEntity entity) {
            this.formationReadyEntities.add(entity);
            this.checkFormationReady();
        }

        private void checkFormationReady() {
            this.adjustFormationSizeToAliveEntities();
            if (this.formationReadyEntities.size() == this.formationSize) {
                this.formationCompleted = true;
            }
        }

        private void adjustFormationSizeToAliveEntities() {
            Iterator<BaseCombatEntity> iterator = this.entities.iterator();
            int aliveEntitiesCount = 0;
            while (iterator.hasNext()) {
                BaseCombatEntity entity = iterator.next();
                if (entity != null && entity.m_6084_()) {
                    ++aliveEntitiesCount;
                    continue;
                }
                iterator.remove();
            }
            this.formationSize = aliveEntitiesCount;
        }

        public boolean isFormationCompleted() {
            this.checkFormationReady();
            return this.formationCompleted;
        }

        public void clearFormation() {
            this.formationReadyEntities.clear();
            this.formationCompleted = false;
        }

        public int getFormationSize() {
            return this.formationSize;
        }

        public void setFormationCompleted(boolean b) {
            this.formationCompleted = b;
        }

        public void setFormDirection(Vec3 formDirection) {
            this.formDirection = formDirection;
        }

        public Vec3 getFormDirection() {
            return this.formDirection;
        }

        public double getFormDistance() {
            return this.formDistance;
        }

        public void setFormDistance(double formDistance) {
            this.formDistance = formDistance;
        }

        public Set<BaseCombatEntity> getEntities() {
            return this.entities;
        }

        public void setEntities(Set<BaseCombatEntity> entities) {
            this.entities = entities;
        }
    }
}

