/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.handler;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.handler.WorshipEffectHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Mod.EventBusSubscriber
public class ModTickHandler {
    private static int damageRecordCleanupCounter = 0;
    private static final int DAMAGE_RECORD_CLEANUP_INTERVAL = 200;
    private static int worshipCheckCounter = 0;
    private static final int WORSHIP_CHECK_INTERVAL = 180;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
            registry.executeAllTasks();
            if (++damageRecordCleanupCounter >= 200) {
                RelationSystem.cleanupExpiredDamageRecords();
                damageRecordCleanupCounter = 0;
            }
            if (++worshipCheckCounter >= 180) {
                worshipCheckCounter = 0;
                ModTickHandler.checkWorshipEffectsForAllPlayers(event.getServer());
            }
        }
    }

    private static void checkWorshipEffectsForAllPlayers(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            WorshipEffectHandler.checkPlayerWorshipEffect(player);
        }
    }
}

