/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.handler;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class WorshipEffectHandler {
    private static final int EFFECT_DURATION = 200;
    private static final double CHECK_RANGE = 20.0;

    public static void checkPlayerWorshipEffect(ServerPlayer player) {
        if (!ServerModConfig.INSTANCE.isEnableWorshipMechanism()) {
            return;
        }
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        AABB searchArea = new AABB(player.m_20185_() - 20.0, player.m_20186_() - 20.0, player.m_20189_() - 20.0, player.m_20185_() + 20.0, player.m_20186_() + 20.0, player.m_20189_() + 20.0);
        List nearbyEntities = player.m_9236_().m_45933_((Entity)player, searchArea);
        int controlledEntityCount = 0;
        UUID playerUUID = player.m_20148_();
        for (Entity entity : nearbyEntities) {
            BaseCombatEntity baseCombatEntity;
            if (!(entity instanceof BaseCombatEntity) || !ServerRelationHelper.hasControlOver((Player)player, (Entity)(baseCombatEntity = (BaseCombatEntity)entity))) continue;
            ++controlledEntityCount;
        }
        int resistanceLevel = WorshipEffectHandler.getResistanceLevel(controlledEntityCount);
        WorshipEffectHandler.applyWorshipEffects(player, resistanceLevel);
    }

    private static int getResistanceLevel(int entityCount) {
        if (entityCount >= 50) {
            return 4;
        }
        if (entityCount >= 20) {
            return 3;
        }
        if (entityCount >= 5) {
            return 2;
        }
        if (entityCount >= 1) {
            return 1;
        }
        return 0;
    }

    private static void applyWorshipEffects(ServerPlayer player, int level) {
        if (level > 0) {
            WorshipEffectHandler.applyResistanceEffect(player, level);
            WorshipEffectHandler.applyRegenerationEffect(player);
        } else {
            WorshipEffectHandler.removeWorshipEffects(player);
        }
    }

    private static void applyResistanceEffect(ServerPlayer player, int level) {
        MobEffect resistance = MobEffects.f_19606_;
        MobEffectInstance currentResistance = player.m_21124_(resistance);
        int worshipAmplifier = level - 1;
        boolean shouldApplyEffect = false;
        if (currentResistance == null) {
            shouldApplyEffect = true;
        } else {
            int currentAmplifier = currentResistance.m_19564_();
            int remainingDuration = currentResistance.m_19557_();
            if (worshipAmplifier >= currentAmplifier && remainingDuration < 200) {
                shouldApplyEffect = true;
            }
        }
        if (shouldApplyEffect) {
            MobEffectInstance worshipResistance = new MobEffectInstance(resistance, 200, worshipAmplifier, true, false, false);
            player.m_7292_(worshipResistance);
        }
    }

    private static void applyRegenerationEffect(ServerPlayer player) {
        MobEffect regeneration = MobEffects.f_19605_;
        MobEffectInstance currentRegeneration = player.m_21124_(regeneration);
        int worshipAmplifier = 0;
        boolean shouldApplyEffect = false;
        if (currentRegeneration == null) {
            shouldApplyEffect = true;
        } else {
            int currentAmplifier = currentRegeneration.m_19564_();
            int remainingDuration = currentRegeneration.m_19557_();
            if (worshipAmplifier >= currentAmplifier && remainingDuration < 200) {
                shouldApplyEffect = true;
            }
        }
        if (shouldApplyEffect) {
            MobEffectInstance worshipRegeneration = new MobEffectInstance(regeneration, 200, worshipAmplifier, true, false, false);
            player.m_7292_(worshipRegeneration);
        }
    }

    private static void removeWorshipEffects(ServerPlayer player) {
        MobEffectInstance currentRegeneration;
        MobEffectInstance currentResistance = player.m_21124_(MobEffects.f_19606_);
        if (currentResistance != null && WorshipEffectHandler.isWorshipResistanceEffect(currentResistance)) {
            player.m_21195_(MobEffects.f_19606_);
        }
        if ((currentRegeneration = player.m_21124_(MobEffects.f_19605_)) != null && WorshipEffectHandler.isWorshipRegenerationEffect(currentRegeneration)) {
            player.m_21195_(MobEffects.f_19605_);
        }
    }

    private static boolean isWorshipResistanceEffect(MobEffectInstance effect) {
        return effect.m_19571_() && !effect.m_19572_() && Math.abs(effect.m_19557_() - 200) <= 20;
    }

    private static boolean isWorshipRegenerationEffect(MobEffectInstance effect) {
        return effect.m_19571_() && !effect.m_19572_() && effect.m_19564_() == 0 && Math.abs(effect.m_19557_() - 200) <= 20;
    }
}

