/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CommandStaffItem
extends Item {
    public static final String TEAM_UUID_LIST_KEY = "TeamEntityUUIDs";
    private static final String ITEM_UUID_KEY = "ItemUUID";
    public static final String TARGET_BLOCK_POS_KEY = "TargetBlockPos";
    public static final String ATTACK_TARGET_ENTITY_KEY = "AttackTargetEntity";
    public static final String ATTACK_MOVE_BLOCK_POS_KEY = "AttackMoveBlockPos";
    private static final int PICK_DISTANCE = 200;

    public CommandStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        CompoundTag nbt;
        if (!level.f_46443_ && entity instanceof Player && !(nbt = stack.m_41784_()).m_128403_(ITEM_UUID_KEY)) {
            nbt.m_128362_(ITEM_UUID_KEY, UUID.randomUUID());
            stack.m_41751_(nbt);
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    private HitResult rayTraceEntities(Player player, double range) {
        Level level = player.m_9236_();
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82520_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
        BlockHitResult blockResult = level.m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            blockDistance = eyePos.m_82554_(blockResult.m_82450_());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityHitResult entityResult = null;
            double entityDistance = Double.MAX_VALUE;
            for (Entity entity : serverLevel.m_8583_()) {
                double distance;
                AABB box;
                Optional hit;
                if (entity == player || !entity.m_6084_() || entity.m_20280_((Entity)player) > range * range || !(hit = (box = entity.m_20191_().m_82400_(0.3)).m_82371_(eyePos, endPos)).isPresent() || !((distance = eyePos.m_82554_((Vec3)hit.get())) < entityDistance) || !(distance < blockDistance)) continue;
                entityDistance = distance;
                entityResult = new EntityHitResult(entity, (Vec3)hit.get());
            }
            if (entityResult != null && entityDistance < blockDistance) {
                return entityResult;
            }
        }
        return blockResult;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return super.m_7579_(stack, target, attacker);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        return super.m_6813_(stack, level, state, pos, entity);
    }

    public static UUID getItemUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128403_(ITEM_UUID_KEY)) {
            return nbt.m_128342_(ITEM_UUID_KEY);
        }
        CompoundTag newNbt = stack.m_41784_();
        UUID uuid = UUID.randomUUID();
        newNbt.m_128362_(ITEM_UUID_KEY, uuid);
        stack.m_41751_(newNbt);
        return uuid;
    }
}

