/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item.army;

import com.google.gson.annotations.SerializedName;
import java.util.List;

public class ArmyData {
    private List<Army> armies;

    public List<Army> getArmies() {
        return this.armies;
    }

    public static class CountRange {
        private int min;
        private int max;

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getRandomCount() {
            return this.min + (int)(Math.random() * (double)(this.max - this.min + 1));
        }
    }

    public static class UnitEntry {
        @SerializedName(value="entity_type")
        private String entityType;
        @SerializedName(value="count_range")
        private CountRange countRange;
        @SerializedName(value="equipment_level")
        private int equipmentLevel;

        public String getEntityType() {
            return this.entityType;
        }

        public CountRange getCountRange() {
            return this.countRange;
        }

        public int getEquipmentLevel() {
            return this.equipmentLevel;
        }
    }

    public static class ExpRange {
        private int min;
        private int max;

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean isInRange(int points) {
            return points >= this.min && points <= this.max;
        }
    }

    public static class Army {
        private String name;
        @SerializedName(value="translation_key")
        private String translationKey;
        private double probability;
        @SerializedName(value="exp_range")
        private ExpRange expRange;
        @SerializedName(value="exp_cost")
        private int expCost;
        private List<UnitEntry> units;

        public String getName() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.translationKey != null ? this.translationKey : "army.hundred_years_war." + this.name.toLowerCase().replace(' ', '_');
        }

        public double getProbability() {
            return this.probability;
        }

        public ExpRange getExpRange() {
            return this.expRange;
        }

        public int getExpCost() {
            return this.expCost;
        }

        public List<UnitEntry> getUnits() {
            return this.units;
        }
    }
}

