/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

@Mixin(value={AbstractArrow.class})
public class AbstractArrowMixin {
    @ModifyVariable(method={"tick"}, at=@At(value="STORE"), ordinal=0)
    private float modifyAirResistance(float m) {
        AbstractArrow arrow = (AbstractArrow)this;
        if (arrow.m_19749_() instanceof BaseCombatEntity && arrow.m_19749_() instanceof RangedAttackMob) {
            return 1.0f;
        }
        return m;
    }

    @ModifyConstant(method={"tickDespawn"}, constant={@Constant(intValue=1200)})
    private int modifyDespawnTime(int original) {
        AbstractArrow arrow = (AbstractArrow)this;
        if (arrow.m_19749_() instanceof BaseCombatEntity && arrow.m_19749_() instanceof RangedAttackMob) {
            return 60;
        }
        return original;
    }

    @Inject(method={"canHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void canHitEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        Entity owner = ((AbstractArrow)this).m_19749_();
        if (owner instanceof BaseCombatEntity) {
            if ((entity instanceof BaseCombatEntity || entity instanceof Player) && !ServerRelationHelper.isEnemyRelation(owner, entity) && !ServerRelationHelper.isNeutralRelation(owner, entity)) {
                cir.setReturnValue((Object)false);
            }
        } else if (owner instanceof Player && (entity instanceof BaseCombatEntity || entity instanceof Player) && (ServerRelationHelper.isFriendlyRelation(owner, entity) || ServerRelationHelper.hasControlOver((Player)owner, entity))) {
            cir.setReturnValue((Object)false);
        }
    }
}

