/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.HoldGoal;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class CommandPacket {
    private final String command;
    private final boolean queueMode;

    public CommandPacket(String command, boolean queueMode) {
        this.command = command;
        this.queueMode = queueMode;
    }

    public static void encode(CommandPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.command);
        buf.writeBoolean(packet.queueMode);
    }

    public static CommandPacket decode(FriendlyByteBuf buf) {
        String command = buf.m_130277_();
        boolean queueMode = buf.readBoolean();
        return new CommandPacket(command, queueMode);
    }

    public static void handle(CommandPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            block3: {
                SelectionSystem.Selection selection;
                block4: {
                    ServerPlayer player = context.getSender();
                    if (player == null || (selection = SelectionSystem.getSelection(player)) == null) break block3;
                    if (!packet.command.equals("hold")) break block4;
                    for (BaseCombatEntity entity : selection.getEntities()) {
                        if (!packet.queueMode) {
                            entity.clearCommandedGoals();
                            entity.setHomePosition(entity.m_20183_());
                        }
                        entity.addCustomGoal(1, new HoldGoal(entity));
                    }
                    break block3;
                }
                if (!packet.command.equals("cancel")) break block3;
                for (BaseCombatEntity entity : selection.getEntities()) {
                    entity.clearCommandedGoals();
                    entity.setHomePosition(entity.m_20183_());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

