/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

public class CommandStaffAddEntityPacket {
    private final UUID staffUUID;
    private final UUID entityUUID;
    private final boolean isAdding;

    public CommandStaffAddEntityPacket(UUID staffUUID, UUID entityUUID, boolean isAdding) {
        this.staffUUID = staffUUID;
        this.entityUUID = entityUUID;
        this.isAdding = isAdding;
    }

    public static void encode(CommandStaffAddEntityPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.staffUUID);
        buf.m_130077_(packet.entityUUID);
        buf.writeBoolean(packet.isAdding);
    }

    public static CommandStaffAddEntityPacket decode(FriendlyByteBuf buf) {
        UUID staffUUID = buf.m_130259_();
        UUID entityUUID = buf.m_130259_();
        boolean isAdding = buf.readBoolean();
        return new CommandStaffAddEntityPacket(staffUUID, entityUUID, isAdding);
    }

    public static void handle(CommandStaffAddEntityPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            UUID staffUUID = packet.staffUUID;
            UUID entityUUID = packet.entityUUID;
            boolean isAdding = packet.isAdding;
            ItemStack staffItem = CommandStaffAddEntityPacket.findCommandStaffItem(player, staffUUID);
            if (staffItem.m_41619_()) {
                return;
            }
            Entity entity = level.m_8791_(entityUUID);
            if (entity == null || !(entity instanceof BaseCombatEntity)) {
                return;
            }
            if (isAdding) {
                CommandStaffAddEntityPacket.addEntityToTeam(staffItem, entityUUID);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.entity_added"), true);
            } else {
                CommandStaffAddEntityPacket.removeEntityFromTeam(staffItem, entityUUID);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.entity_removed"), true);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack findCommandStaffItem(ServerPlayer player, UUID staffUUID) {
        UUID itemUUID;
        UUID itemUUID2;
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof CommandStaffItem && (itemUUID2 = CommandStaffItem.getItemUUID(mainHandItem)).equals(staffUUID)) {
            return mainHandItem;
        }
        ItemStack offHandItem = player.m_21206_();
        if (!offHandItem.m_41619_() && offHandItem.m_41720_() instanceof CommandStaffItem && (itemUUID = CommandStaffItem.getItemUUID(offHandItem)).equals(staffUUID)) {
            return offHandItem;
        }
        return ItemStack.f_41583_;
    }

    private static void addEntityToTeam(ItemStack staffItem, UUID entityUUID) {
        CompoundTag nbt = staffItem.m_41784_();
        ListTag teamList = nbt.m_128425_("TeamEntityUUIDs", 9) ? nbt.m_128437_("TeamEntityUUIDs", 8) : new ListTag();
        String entityUUIDString = entityUUID.toString();
        boolean alreadyInList = false;
        for (int i = 0; i < teamList.size(); ++i) {
            if (!teamList.m_128778_(i).equals(entityUUIDString)) continue;
            alreadyInList = true;
            break;
        }
        if (!alreadyInList) {
            teamList.add((Object)StringTag.m_129297_((String)entityUUIDString));
            nbt.m_128365_("TeamEntityUUIDs", (Tag)teamList);
        }
    }

    private static void removeEntityFromTeam(ItemStack staffItem, UUID entityUUID) {
        CompoundTag nbt = staffItem.m_41783_();
        if (nbt != null && nbt.m_128425_("TeamEntityUUIDs", 9)) {
            ListTag teamList = nbt.m_128437_("TeamEntityUUIDs", 8);
            String entityUUIDString = entityUUID.toString();
            ListTag newTeamList = new ListTag();
            for (int i = 0; i < teamList.size(); ++i) {
                String uuidString = teamList.m_128778_(i);
                if (uuidString.equals(entityUUIDString)) continue;
                newTeamList.add((Object)StringTag.m_129297_((String)uuidString));
            }
            nbt.m_128365_("TeamEntityUUIDs", (Tag)newTeamList);
        }
    }
}

