/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.TargetAttackGoal;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

public class CommandStaffAttackPacket {
    private final UUID staffUUID;
    private final UUID targetEntityUUID;

    public CommandStaffAttackPacket(UUID staffUUID, UUID targetEntityUUID) {
        this.staffUUID = staffUUID;
        this.targetEntityUUID = targetEntityUUID;
    }

    public static void encode(CommandStaffAttackPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.staffUUID);
        buf.m_130077_(packet.targetEntityUUID);
    }

    public static CommandStaffAttackPacket decode(FriendlyByteBuf buf) {
        UUID staffUUID = buf.m_130259_();
        UUID targetEntityUUID = buf.m_130259_();
        return new CommandStaffAttackPacket(staffUUID, targetEntityUUID);
    }

    public static void handle(CommandStaffAttackPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            UUID staffUUID = packet.staffUUID;
            UUID targetEntityUUID = packet.targetEntityUUID;
            ItemStack staffItem = CommandStaffAttackPacket.findCommandStaffItem(player, staffUUID);
            if (staffItem.m_41619_()) {
                return;
            }
            Entity targetEntity = level.m_8791_(targetEntityUUID);
            if (!(targetEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity targetLiving = (LivingEntity)targetEntity;
            CompoundTag nbt = staffItem.m_41784_();
            nbt.m_128473_("TargetBlockPos");
            nbt.m_128473_("AttackMoveBlockPos");
            nbt.m_128362_("AttackTargetEntity", targetEntityUUID);
            staffItem.m_41751_(nbt);
            if (nbt.m_128425_("TeamEntityUUIDs", 9)) {
                ListTag uuidList = nbt.m_128437_("TeamEntityUUIDs", 8);
                for (int i = 0; i < uuidList.size(); ++i) {
                    String uuidString = uuidList.m_128778_(i);
                    try {
                        UUID entityUUID = UUID.fromString(uuidString);
                        Entity entity = level.m_8791_(entityUUID);
                        if (!(entity instanceof BaseCombatEntity)) continue;
                        BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                        TargetAttackGoal attackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetLiving);
                        combatEntity.clearCommandedGoals();
                        combatEntity.addCustomGoal(1, attackGoal);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack findCommandStaffItem(ServerPlayer player, UUID staffUUID) {
        UUID itemUUID;
        UUID itemUUID2;
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof CommandStaffItem && (itemUUID2 = CommandStaffItem.getItemUUID(mainHandItem)).equals(staffUUID)) {
            return mainHandItem;
        }
        ItemStack offHandItem = player.m_21206_();
        if (!offHandItem.m_41619_() && offHandItem.m_41720_() instanceof CommandStaffItem && (itemUUID = CommandStaffItem.getItemUUID(offHandItem)).equals(staffUUID)) {
            return offHandItem;
        }
        return ItemStack.f_41583_;
    }

    private static List<UUID> getTeamEntityUUIDs(ItemStack staffItem) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        CompoundTag nbt = staffItem.m_41783_();
        if (nbt != null && nbt.m_128425_("TeamEntityUUIDs", 9)) {
            ListTag teamList = nbt.m_128437_("TeamEntityUUIDs", 8);
            for (int i = 0; i < teamList.size(); ++i) {
                String uuidString = teamList.m_128778_(i);
                try {
                    UUID entityUUID = UUID.fromString(uuidString);
                    result.add(entityUUID);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

