/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class FollowTargetPacket {
    private final UUID targetUUID;
    private final boolean queueMode;

    public FollowTargetPacket(UUID targetUUID, boolean queueMode) {
        this.targetUUID = targetUUID;
        this.queueMode = queueMode;
    }

    public static void encode(FollowTargetPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.targetUUID);
        buf.writeBoolean(packet.queueMode);
    }

    public static FollowTargetPacket decode(FriendlyByteBuf buf) {
        UUID targetUUID = buf.m_130259_();
        boolean queueMode = buf.readBoolean();
        return new FollowTargetPacket(targetUUID, queueMode);
    }

    public static void handle(FollowTargetPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerLevel world;
            Entity targetEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (targetEntity = (world = (ServerLevel)((EntityAccessor)player).getLevel()).m_8791_(packet.targetUUID)) instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)targetEntity;
                SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
                if (selection != null) {
                    for (BaseCombatEntity entity : selection.getEntities()) {
                        if (!packet.queueMode) {
                            entity.clearCommandedGoals();
                        }
                        entity.setFollowTarget(livingTarget);
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

