/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.utils.FreecamStateManager;
import ydmsama.hundred_years_war.main.utils.PuppetManager;

public class FreecamTogglePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "freecam_toggle_packet");
    private final boolean isEnabled;

    public FreecamTogglePacket(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public static void encode(FreecamTogglePacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.isEnabled);
    }

    public static FreecamTogglePacket decode(FriendlyByteBuf buf) {
        boolean isEnabled = buf.readBoolean();
        return new FreecamTogglePacket(isEnabled);
    }

    public static void handle(FreecamTogglePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                FreecamTogglePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, FreecamTogglePacket packet) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        FreecamStateManager.setPlayerFreecamState(player, packet.isEnabled);
        if (ServerModConfig.INSTANCE.isEnablePlayerPuppets()) {
            if (packet.isEnabled) {
                PuppetManager.createPuppetForPlayer(player);
            } else {
                PuppetManager.removePuppetForPlayer(player);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

