/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class PatrolPointPacket {
    private final BlockHitResult hitResult;
    private final boolean queueMode;

    public PatrolPointPacket(BlockHitResult hitResult, boolean queueMode) {
        this.hitResult = hitResult;
        this.queueMode = queueMode;
    }

    public static void encode(PatrolPointPacket packet, FriendlyByteBuf buf) {
        buf.m_130062_(packet.hitResult);
        buf.writeBoolean(packet.queueMode);
    }

    public static PatrolPointPacket decode(FriendlyByteBuf buf) {
        BlockHitResult hitResult = buf.m_130283_();
        boolean queueMode = buf.readBoolean();
        return new PatrolPointPacket(hitResult, queueMode);
    }

    public static void handle(PatrolPointPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            SelectionSystem.Selection selection;
            ServerPlayer player = context.getSender();
            if (player != null && (selection = SelectionSystem.getSelection(player)) != null) {
                for (BaseCombatEntity entity : selection.getEntities()) {
                    if (!packet.queueMode) {
                        entity.clearCommandedGoals();
                    }
                    entity.getPatrolPoints().add(packet.hitResult.m_82425_());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

