/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class RelationRequestPacket {
    public static final ResourceLocation RELATION_REQUEST_PACKET_ID = new ResourceLocation("hundred_years_war", "relation_request_packet");

    public RelationRequestPacket() {
    }

    public RelationRequestPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static RelationRequestPacket decode(FriendlyByteBuf buf) {
        return new RelationRequestPacket(buf);
    }

    public static boolean handle(RelationRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                RelationRequestPacket.handlePacket(player);
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public static void handlePacket(ServerPlayer player) {
        RelationResponsePacket responsePacket = new RelationResponsePacket();
        FriendlyByteBuf responseBuf = new FriendlyByteBuf(Unpooled.buffer());
        UUID playerUUID = player.m_20148_();
        PlayerRelationData playerData = RelationSystem.getOrCreatePlayerRelationData(playerUUID, player.m_7755_().getString());
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        for (Map.Entry<UUID, RelationData> entry : RelationSystem.getAllRelationData().entrySet()) {
            RelationSystem.RelationType theirRelation;
            RelationSystem.RelationType myRelation;
            UUID targetUUID = entry.getKey();
            RelationData relationData = entry.getValue();
            if (relationData instanceof PlayerRelationData) {
                PlayerRelationData targetPlayerData = (PlayerRelationData)relationData;
                if (targetUUID.equals(playerUUID)) continue;
                myRelation = RelationSystem.getRelation(playerUUID, targetUUID);
                theirRelation = RelationSystem.getRelation(targetUUID, playerUUID);
                responsePacket.addRelationInfo(targetUUID, targetPlayerData.getPlayerName(), myRelation, theirRelation);
                continue;
            }
            if (!(relationData instanceof TeamRelationData)) continue;
            TeamRelationData teamData = (TeamRelationData)relationData;
            myRelation = RelationSystem.getRelation(playerUUID, targetUUID);
            theirRelation = RelationSystem.getRelation(targetUUID, playerUUID);
            responsePacket.addTeamInfo(targetUUID, teamData.getTeamName(), myRelation, teamData.getAllMembers(), playerTeams, theirRelation);
        }
        responsePacket.encode(responseBuf);
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }
}

