/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class RelationResponsePacket {
    public static final ResourceLocation RELATION_RESPONSE_PACKET_ID = new ResourceLocation("hundred_years_war", "relation_response_packet");
    private final Map<UUID, RelationInfo> relationInfoMap = new HashMap<UUID, RelationInfo>();
    private final Map<UUID, TeamInfo> teamInfoMap = new HashMap<UUID, TeamInfo>();

    public static RelationResponsePacket decode(FriendlyByteBuf buf) {
        RelationResponsePacket packet = new RelationResponsePacket();
        int playerCount = buf.readInt();
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = buf.m_130259_();
            String playerName = buf.m_130277_();
            RelationSystem.RelationType myRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            packet.addRelationInfo(uuid, playerName, myRelation, theirRelation);
        }
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID teamUuid = buf.m_130259_();
            String teamName = buf.m_130277_();
            RelationSystem.RelationType myRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            int memberCount = buf.readInt();
            HashMap<UUID, TeamRelationData.MemberType> members = new HashMap<UUID, TeamRelationData.MemberType>();
            for (int j = 0; j < memberCount; ++j) {
                UUID memberUuid = buf.m_130259_();
                TeamRelationData.MemberType memberType = TeamRelationData.MemberType.valueOf(buf.m_130277_());
                members.put(memberUuid, memberType);
            }
            int myTeamsCount = buf.readInt();
            ArrayList<UUID> myTeams = new ArrayList<UUID>();
            for (int j = 0; j < myTeamsCount; ++j) {
                myTeams.add(buf.m_130259_());
            }
            packet.addTeamInfo(teamUuid, teamName, myRelation, members, myTeams, theirRelation);
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.relationInfoMap.size());
        for (Map.Entry<UUID, RelationInfo> entry : this.relationInfoMap.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130070_(entry.getValue().getPlayerName());
            buf.m_130070_(entry.getValue().getMyRelation().name());
            buf.m_130070_(entry.getValue().getTheirRelation().name());
        }
        buf.writeInt(this.teamInfoMap.size());
        for (Map.Entry<UUID, Object> entry : this.teamInfoMap.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130070_(((TeamInfo)entry.getValue()).getTeamName());
            buf.m_130070_(((TeamInfo)entry.getValue()).getMyRelation().name());
            buf.m_130070_(((TeamInfo)entry.getValue()).getTheirRelation().name());
            Map<UUID, TeamRelationData.MemberType> members = ((TeamInfo)entry.getValue()).getMembers();
            buf.writeInt(members.size());
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : members.entrySet()) {
                buf.m_130077_(memberEntry.getKey());
                buf.m_130070_(memberEntry.getValue().name());
            }
            List<UUID> myTeams = ((TeamInfo)entry.getValue()).getMyTeams();
            buf.writeInt(myTeams.size());
            for (UUID teamUuid : myTeams) {
                buf.m_130077_(teamUuid);
            }
        }
    }

    public void addRelationInfo(UUID uuid, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
        this.relationInfoMap.put(uuid, new RelationInfo(playerName, myRelation, theirRelation));
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams) {
        this.addTeamInfo(teamUuid, teamName, myRelation, members, myTeams, RelationSystem.RelationType.NEUTRAL);
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams, RelationSystem.RelationType theirRelation) {
        this.teamInfoMap.put(teamUuid, new TeamInfo(teamName, myRelation, members, myTeams, theirRelation));
    }

    public Map<UUID, RelationInfo> getRelationInfoMap() {
        return this.relationInfoMap;
    }

    public Map<UUID, TeamInfo> getTeamInfoMap() {
        return this.teamInfoMap;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.onRelationResponse(this)));
        context.get().setPacketHandled(true);
    }

    public static class RelationInfo {
        private final String playerName;
        private final RelationSystem.RelationType myRelation;
        private final RelationSystem.RelationType theirRelation;

        public RelationInfo(String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
            this.playerName = playerName;
            this.myRelation = myRelation;
            this.theirRelation = theirRelation;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }
    }

    public static class TeamInfo {
        private final String teamName;
        private final RelationSystem.RelationType myRelation;
        private final Map<UUID, TeamRelationData.MemberType> members;
        private final List<UUID> myTeams;
        private RelationSystem.RelationType theirRelation;

        public TeamInfo(String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams) {
            this(teamName, myRelation, members, myTeams, RelationSystem.RelationType.NEUTRAL);
        }

        public TeamInfo(String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams, RelationSystem.RelationType theirRelation) {
            this.teamName = teamName;
            this.myRelation = myRelation;
            this.members = members;
            this.myTeams = myTeams;
            this.theirRelation = theirRelation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public Map<UUID, TeamRelationData.MemberType> getMembers() {
            return this.members;
        }

        public List<UUID> getMyTeams() {
            return this.myTeams;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public void setTheirRelation(RelationSystem.RelationType theirRelation) {
            this.theirRelation = theirRelation;
        }
    }
}

