/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class RelationSyncPacket {
    public static final ResourceLocation RELATION_SYNC_PACKET_ID = new ResourceLocation("hundred_years_war", "relation_sync_packet");
    private final Set<UUID> enemyUUIDs;
    private final Set<UUID> sharedControlUUIDs;

    public RelationSyncPacket(Set<UUID> enemyUUIDs, Set<UUID> sharedControlUUIDs) {
        this.enemyUUIDs = enemyUUIDs;
        this.sharedControlUUIDs = sharedControlUUIDs;
    }

    public Set<UUID> getEnemyUUIDs() {
        return this.enemyUUIDs;
    }

    public Set<UUID> getSharedControlUUIDs() {
        return this.sharedControlUUIDs;
    }

    public static void encode(RelationSyncPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.enemyUUIDs.size());
        for (UUID uuid : packet.enemyUUIDs) {
            buf.m_130077_(uuid);
        }
        buf.writeInt(packet.sharedControlUUIDs.size());
        for (UUID uuid : packet.sharedControlUUIDs) {
            buf.m_130077_(uuid);
        }
    }

    public static RelationSyncPacket decode(FriendlyByteBuf buf) {
        int enemySize = buf.readInt();
        HashSet<UUID> enemyUUIDs = new HashSet<UUID>();
        for (int i = 0; i < enemySize; ++i) {
            enemyUUIDs.add(buf.m_130259_());
        }
        int sharedControlSize = buf.readInt();
        HashSet<UUID> sharedControlUUIDs = new HashSet<UUID>();
        for (int i = 0; i < sharedControlSize; ++i) {
            sharedControlUUIDs.add(buf.m_130259_());
        }
        return new RelationSyncPacket(enemyUUIDs, sharedControlUUIDs);
    }

    public static void sendToClient(ServerPlayer player) {
        UUID playerUUID = player.m_20148_();
        HashSet<UUID> enemyUUIDs = new HashSet<UUID>();
        enemyUUIDs.addAll(RelationSystem.getRelationsByType(playerUUID, RelationSystem.RelationType.HOSTILE).keySet());
        HashSet<UUID> sharedControlUUIDs = new HashSet<UUID>();
        for (UUID otherUUID : RelationSystem.getAllRelationData().keySet()) {
            if (otherUUID.equals(playerUUID) || RelationSystem.getRelation(otherUUID, playerUUID) != RelationSystem.RelationType.CONTROL) continue;
            sharedControlUUIDs.add(otherUUID);
        }
        RelationSyncPacket packet = new RelationSyncPacket(enemyUUIDs, sharedControlUUIDs);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        RelationSyncPacket.encode(packet, buf);
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.onRelationSync(this)));
        context.get().setPacketHandled(true);
    }
}

