/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.network.packets.StructureSizePacket;

public class RequestTemplateSizePacket {
    private final String templateName;

    public RequestTemplateSizePacket(String templateName) {
        this.templateName = templateName;
    }

    public static void encode(RequestTemplateSizePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.templateName);
    }

    public static RequestTemplateSizePacket decode(FriendlyByteBuf buf) {
        String templateName = buf.m_130277_();
        return new RequestTemplateSizePacket(templateName);
    }

    public static void handle(RequestTemplateSizePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        context.enqueueWork(() -> {
            if (player != null) {
                ResourceLocation templateLocation = new ResourceLocation("hundred_years_war", packet.templateName);
                ServerLevel serverLevel = (ServerLevel)((EntityAccessor)player).getLevel();
                StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
                Optional templateOptional = structureTemplateManager.m_230407_(templateLocation);
                templateOptional.ifPresent(template -> StructureSizePacket.sendToClient(player, template));
            }
        });
        context.setPacketHandled(true);
    }
}

