/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class SelectionPacket {
    private final List<UUID> selectedEntityIds;

    public SelectionPacket(List<UUID> selectedEntityIds) {
        this.selectedEntityIds = selectedEntityIds;
    }

    public static void encode(SelectionPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.selectedEntityIds.size());
        for (UUID id : packet.selectedEntityIds) {
            buf.m_130077_(id);
        }
    }

    public static SelectionPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<UUID> selectedEntityIds = new ArrayList<UUID>();
        for (int i = 0; i < size; ++i) {
            selectedEntityIds.add(buf.m_130259_());
        }
        return new SelectionPacket(selectedEntityIds);
    }

    public static void handle(SelectionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                Optional.ofNullable(SelectionSystem.getSelection(player)).ifPresent(SelectionSystem.Selection::clear);
                if (!packet.selectedEntityIds.isEmpty()) {
                    SelectionSystem.addEntitiesToSelection(player, packet.selectedEntityIds);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

