/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;

public class SquadCreatePacket {
    private final int squadNumber;

    public SquadCreatePacket(int squadNumber) {
        this.squadNumber = squadNumber;
    }

    public static void encode(SquadCreatePacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.squadNumber);
    }

    public static SquadCreatePacket decode(FriendlyByteBuf buf) {
        int squadNumber = buf.readInt();
        return new SquadCreatePacket(squadNumber);
    }

    public static void handle(SquadCreatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                SquadCreatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, SquadCreatePacket packet) {
        int number = packet.squadNumber;
        SelectionSystem.Selection currentSelection = SelectionSystem.getSelection(player);
        if (currentSelection != null) {
            SelectionSystem.getSquads().computeIfAbsent(player.m_20148_(), k -> new ArrayList());
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            while (playerSquads.size() <= number) {
                playerSquads.add(null);
            }
            List<UUID> entityUUIDs = currentSelection.getEntityUUIDs();
            SelectionSystem.Squad squad = new SelectionSystem.Squad(entityUUIDs);
            playerSquads.set(number, squad);
            if (SquadCreatePacket.containsPuppetEntity(player, entityUUIDs)) {
                PuppetStateHandler.updatePuppetSquadState(player.m_20148_(), number, entityUUIDs);
            } else {
                PuppetStateHandler.clearPuppetSquadState(player.m_20148_(), number);
            }
        }
    }

    private static boolean containsPuppetEntity(ServerPlayer player, List<UUID> entityUUIDs) {
        ServerLevel serverWorld = (ServerLevel)((EntityAccessor)player).getLevel();
        for (UUID entityUUID : entityUUIDs) {
            Entity entity = serverWorld.m_8791_(entityUUID);
            if (!(entity instanceof IPuppet)) continue;
            IPuppet puppet = (IPuppet)entity;
            if (!player.m_20148_().equals(puppet.getOwnerUUID())) continue;
            return true;
        }
        return false;
    }

    public int getNumber() {
        return this.squadNumber;
    }
}

