/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.SquadPacket;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class SquadSelectPacket {
    private final int squadNumber;

    public SquadSelectPacket(int squadNumber) {
        this.squadNumber = squadNumber;
    }

    public static void encode(SquadSelectPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.squadNumber);
    }

    public static SquadSelectPacket decode(FriendlyByteBuf buf) {
        int squadNumber = buf.readInt();
        return new SquadSelectPacket(squadNumber);
    }

    public static void handle(SquadSelectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        context.enqueueWork(() -> {
            SelectionSystem.Squad selectedSquad;
            List<SelectionSystem.Squad> playerSquads;
            if (player != null && (playerSquads = SelectionSystem.getSquads().get(player.m_20148_())) != null && packet.squadNumber >= 0 && packet.squadNumber < playerSquads.size() && (selectedSquad = playerSquads.get(packet.squadNumber)) != null) {
                ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
                ArrayList<BaseCombatEntity> selectedEntities = new ArrayList<BaseCombatEntity>();
                for (UUID entityUUID : selectedSquad.getEntityUUIDs()) {
                    Entity entity = world.m_8791_(entityUUID);
                    if (!(entity instanceof BaseCombatEntity)) continue;
                    BaseCombatEntity baseEntity = (BaseCombatEntity)entity;
                    selectedEntities.add(baseEntity);
                }
                if (!selectedEntities.isEmpty()) {
                    SelectionSystem.Selection newSelection = new SelectionSystem.Selection(selectedEntities);
                    SelectionSystem.getSelections().put(player, newSelection);
                    SquadPacket responsePacket = new SquadPacket(selectedSquad.getEntityUUIDs());
                    ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

