/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.client.structure.BuildModeRenderer;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

public class StructureSizePacket {
    private final Vec3i size;

    public StructureSizePacket(Vec3i size) {
        this.size = size;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public static void encode(StructureSizePacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.size.m_123341_());
        buf.m_130130_(packet.size.m_123342_());
        buf.m_130130_(packet.size.m_123343_());
    }

    public static StructureSizePacket decode(FriendlyByteBuf buf) {
        int x = buf.m_130242_();
        int y = buf.m_130242_();
        int z = buf.m_130242_();
        return new StructureSizePacket(new Vec3i(x, y, z));
    }

    public static void handle(StructureSizePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> Minecraft.m_91087_().execute(() -> BuildModeRenderer.updateStructureSize(packet.getSize())));
        }
        context.setPacketHandled(true);
    }

    public static void sendToClient(ServerPlayer player, StructureTemplate template) {
        Vec3i size = template.m_163801_();
        StructureSizePacket packet = new StructureSizePacket(size);
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }
}

