/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class TeamApplicationsResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_applications_response");
    private final List<Application> applications;

    public TeamApplicationsResponsePacket(List<Application> applications) {
        this.applications = applications;
    }

    public TeamApplicationsResponsePacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.applications = new ArrayList<Application>(size);
        for (int i = 0; i < size; ++i) {
            String playerName = buf.m_130277_();
            UUID playerUUID = buf.m_130259_();
            long applyTime = buf.readLong();
            this.applications.add(new Application(playerName, playerUUID, applyTime));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.applications.size());
        for (Application app : this.applications) {
            buf.m_130070_(app.getPlayerName());
            buf.m_130077_(app.getPlayerUUID());
            buf.writeLong(app.getApplyTime());
        }
    }

    public static TeamApplicationsResponsePacket decode(FriendlyByteBuf buf) {
        return new TeamApplicationsResponsePacket(buf);
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePacket() {
        Minecraft.m_91087_().execute(() -> ClientPacketHandler.onTeamApplicationsResponse(this));
    }

    public static void handle(TeamApplicationsResponsePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> packet.handlePacket());
        }
        context.setPacketHandled(true);
    }

    public static class Application {
        private final String playerName;
        private final UUID playerUUID;
        private final long applyTime;

        public Application(String playerName, UUID playerUUID, long applyTime) {
            this.playerName = playerName;
            this.playerUUID = playerUUID;
            this.applyTime = applyTime;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public long getApplyTime() {
            return this.applyTime;
        }
    }
}

