/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class TeamCreateResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_create_response");
    private final boolean success;
    private final String message;
    private final UUID teamUUID;

    public TeamCreateResponsePacket(boolean success, String message, UUID teamUUID) {
        this.success = success;
        this.message = message;
        this.teamUUID = teamUUID != null ? teamUUID : new UUID(0L, 0L);
    }

    public TeamCreateResponsePacket(FriendlyByteBuf buf) {
        this.success = buf.readBoolean();
        this.message = buf.m_130277_();
        this.teamUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.success);
        buf.m_130070_(this.message);
        buf.m_130077_(this.teamUUID);
    }

    public static TeamCreateResponsePacket decode(FriendlyByteBuf buf) {
        return new TeamCreateResponsePacket(buf);
    }

    public static void handle(TeamCreateResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TeamCreateResponsePacket.handlePacket(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(TeamCreateResponsePacket packet) {
        ClientPacketHandler.onTeamCreateResponse(packet);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }
}

