/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamJoinRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_join");
    private final UUID teamUUID;

    public TeamJoinRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamJoinRequestPacket(FriendlyByteBuf buf) {
        this.teamUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
    }

    public static TeamJoinRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamJoinRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(TeamJoinRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamJoinRequestPacket.handlePacket(player, packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, TeamJoinRequestPacket packet) {
        UUID playerUUID = player.m_20148_();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        if (teamData.isMember(playerUUID)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.already_in_team"));
            return;
        }
        if (teamData.hasApplication(playerUUID)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.already_applied"));
            return;
        }
        teamData.addApplication(playerUUID);
        player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.application_sent", (Object[])new Object[]{teamData.getTeamName()}));
        for (Map.Entry<UUID, TeamRelationData.MemberType> entry : teamData.getAllMembers().entrySet()) {
            ServerPlayer member;
            UUID memberUUID = entry.getKey();
            TeamRelationData.MemberType memberType = entry.getValue();
            if (memberType != TeamRelationData.MemberType.OWNER && memberType != TeamRelationData.MemberType.ADMIN || (member = player.m_20194_().m_6846_().m_11259_(memberUUID)) == null) continue;
            member.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.new_application", (Object[])new Object[]{player.m_7755_().getString()}));
        }
        TeamInfoRequestPacket.handlePacket(player);
    }
}

