/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.selection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class SelectionSystem {
    private static final Map<ServerPlayer, Selection> selections = new ConcurrentHashMap<ServerPlayer, Selection>();
    private static final Map<UUID, List<Squad>> squads = new ConcurrentHashMap<UUID, List<Squad>>();

    public static void saveSquads(Path savePath) throws IOException {
        CompoundTag nbt = new CompoundTag();
        ListTag squadList = new ListTag();
        for (Map.Entry<UUID, List<Squad>> entry : squads.entrySet()) {
            UUID playerUUID = entry.getKey();
            List<Squad> playerSquads = entry.getValue();
            CompoundTag playerData = new CompoundTag();
            playerData.m_128362_("PlayerUUID", playerUUID);
            ListTag squadsTag = new ListTag();
            for (Squad squad : playerSquads) {
                if (squad == null) continue;
                CompoundTag squadTag = new CompoundTag();
                ListTag entityUUIDsTag = new ListTag();
                for (UUID entityUUID : squad.getEntityUUIDs()) {
                    entityUUIDsTag.add((Object)StringTag.m_129297_((String)entityUUID.toString()));
                }
                squadTag.m_128365_("EntityUUIDs", (Tag)entityUUIDsTag);
                squadsTag.add((Object)squadTag);
            }
            playerData.m_128365_("Squads", (Tag)squadsTag);
            squadList.add((Object)playerData);
        }
        nbt.m_128365_("Squads", (Tag)squadList);
        NbtIo.m_128944_((CompoundTag)nbt, (File)savePath.toFile());
    }

    public static void loadSquads(Path savePath) throws IOException {
        if (Files.exists(savePath, new LinkOption[0])) {
            try {
                CompoundTag nbt = NbtIo.m_128937_((File)savePath.toFile());
                ListTag squadList = nbt.m_128437_("Squads", 10);
                squads.clear();
                for (int i = 0; i < squadList.size(); ++i) {
                    CompoundTag playerData = squadList.m_128728_(i);
                    UUID playerUUID = playerData.m_128342_("PlayerUUID");
                    ListTag squadsTag = playerData.m_128437_("Squads", 10);
                    ArrayList<Squad> playerSquads = new ArrayList<Squad>();
                    for (int j = 0; j < squadsTag.size(); ++j) {
                        CompoundTag squadTag = squadsTag.m_128728_(j);
                        ListTag entityUUIDsTag = squadTag.m_128437_("EntityUUIDs", 8);
                        ArrayList<UUID> entityUUIDs = new ArrayList<UUID>();
                        for (int k = 0; k < entityUUIDsTag.size(); ++k) {
                            entityUUIDs.add(UUID.fromString(entityUUIDsTag.m_128778_(k)));
                        }
                        playerSquads.add(new Squad(entityUUIDs));
                    }
                    squads.put(playerUUID, playerSquads);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Selection getSelection(ServerPlayer player) {
        return selections.computeIfAbsent(player, k -> new Selection(new ArrayList<BaseCombatEntity>()));
    }

    public static Map<ServerPlayer, Selection> getSelections() {
        return selections;
    }

    public static Map<UUID, List<Squad>> getSquads() {
        return squads;
    }

    public static void addEntitiesToSelection(ServerPlayer player, List<UUID> entityUUIDs) {
        Selection selection = selections.getOrDefault(player, new Selection(new ArrayList<BaseCombatEntity>()));
        selection.clear();
        for (UUID uuid : entityUUIDs) {
            Entity entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
            if (!(entity instanceof BaseCombatEntity) || !ServerRelationHelper.hasControlOver((Player)player, entity) && !player.m_7500_()) continue;
            selection.addEntity((BaseCombatEntity)entity);
        }
        selections.put(player, selection);
    }

    public static Entity getEntityByUUIDWithinRadius(ServerPlayer player, UUID uuid, int radius) {
        Vec3 playerPos = player.m_20182_();
        AABB selectionBox = new AABB(playerPos.f_82479_ - (double)radius, playerPos.f_82480_ - (double)radius, playerPos.f_82481_ - (double)radius, playerPos.f_82479_ + (double)radius, playerPos.f_82480_ + (double)radius, playerPos.f_82481_ + (double)radius);
        return ((EntityAccessor)player).getLevel().m_6443_(Entity.class, selectionBox, entity -> entity.m_20148_().equals(uuid)).stream().findFirst().orElse(null);
    }

    public static void clearEntityFromAllSelections(BaseCombatEntity entity) {
        for (Selection selection : selections.values()) {
            selection.removeEntity(entity);
        }
    }

    public static class Squad {
        private List<UUID> entityUUIDs;

        public Squad(List<UUID> entityUUIDs) {
            this.entityUUIDs = entityUUIDs;
        }

        public List<UUID> getEntityUUIDs() {
            return this.entityUUIDs;
        }

        public void setEntityUUIDs(List<UUID> entityUUIDs) {
            this.entityUUIDs = entityUUIDs;
        }
    }

    public static class Selection {
        private List<BaseCombatEntity> entities;

        public Selection(List<BaseCombatEntity> entities) {
            this.entities = new ArrayList<BaseCombatEntity>(entities);
        }

        public List<BaseCombatEntity> getEntities() {
            return new ArrayList<BaseCombatEntity>(this.entities);
        }

        public void refreshEntities() {
            this.entities = this.entities.stream().filter(LivingEntity::m_6084_).collect(Collectors.toList());
        }

        public void addEntity(BaseCombatEntity entity) {
            if (entity != null && !this.entities.contains((Object)entity)) {
                this.entities.add(entity);
            }
        }

        public void clear() {
            this.entities.clear();
        }

        public List<UUID> getEntityUUIDs() {
            return this.entities.stream().map(Entity::m_20148_).collect(Collectors.toList());
        }

        public void removeEntity(BaseCombatEntity entity) {
            this.entities.remove((Object)entity);
        }
    }
}

