/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class BetterMobCombatIntegration {
    private static boolean isBetterMobCombatLoaded = false;
    private static boolean checkPerformed = false;
    private static Class<?> weaponRegistryClass;
    private static Class<?> weaponAttributesClass;
    private static Class<?> weaponAttributesAttackClass;
    private static Class<?> mobCombatHelperClass;
    private static Class<?> mobTargetFinderClass;
    private static Class<?> attackHandClass;
    private static Class<?> mobAttackHelperClass;
    private static Class<?> mobAttackWindupClass;
    private static Class<?> betterMobCombatClass;
    private static Class<?> bmcServerConfigClass;
    private static Method getAttributesMethod;
    private static Method attacksMethod;
    private static Method processAttackMethod;
    private static Method findAttackTargetsMethod;
    private static Method getCurrentAttackMethod;
    private static Method angleMethod;
    private static Method startUpswingMethod;
    private static Method getServerConfigMethod;
    private static Method updateServerConfigMethod;
    private static Field sameEntityTypeField;

    private static void checkAndLoadBetterMobCombat() {
        if (checkPerformed) {
            return;
        }
        try {
            weaponRegistryClass = Class.forName("net.bettercombat.logic.WeaponRegistry");
            weaponAttributesClass = Class.forName("net.bettercombat.api.WeaponAttributes");
            weaponAttributesAttackClass = Class.forName("net.bettercombat.api.WeaponAttributes$Attack");
            mobCombatHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper");
            mobTargetFinderClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobTargetFinder");
            attackHandClass = Class.forName("net.bettercombat.api.AttackHand");
            mobAttackHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper");
            mobAttackWindupClass = Class.forName("me.Thelnfamous1.bettermobcombat.api.MobAttackWindup");
            betterMobCombatClass = Class.forName("me.Thelnfamous1.bettermobcombat.BetterMobCombat");
            bmcServerConfigClass = Class.forName("me.Thelnfamous1.bettermobcombat.config.BMCServerConfig");
            getAttributesMethod = weaponRegistryClass.getMethod("getAttributes", ItemStack.class);
            attacksMethod = weaponAttributesClass.getMethod("attacks", new Class[0]);
            processAttackMethod = mobCombatHelperClass.getMethod("processAttack", Level.class, Mob.class, Integer.TYPE, List.class, BiConsumer.class);
            findAttackTargetsMethod = mobTargetFinderClass.getMethod("findAttackTargets", LivingEntity.class, Entity.class, weaponAttributesAttackClass, Double.TYPE);
            getCurrentAttackMethod = mobAttackHelperClass.getMethod("getCurrentAttack", LivingEntity.class, Integer.TYPE);
            angleMethod = weaponAttributesAttackClass.getMethod("angle", new Class[0]);
            startUpswingMethod = mobAttackWindupClass.getMethod("bettermobcombat$startUpswing", weaponAttributesClass, BiConsumer.class);
            getServerConfigMethod = betterMobCombatClass.getMethod("getServerConfig", new Class[0]);
            updateServerConfigMethod = betterMobCombatClass.getMethod("updateServerConfig", bmcServerConfigClass, Boolean.TYPE);
            sameEntityTypeField = bmcServerConfigClass.getField("mobs_check_for_same_entity_type");
            isBetterMobCombatLoaded = true;
            System.out.println("[HundredYearsWar] Better Mob Combat integration loaded successfully");
            if (ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
                BetterMobCombatIntegration.disableSameEntityTypeCheck();
            }
        }
        catch (Exception e) {
            isBetterMobCombatLoaded = false;
            System.out.println("[HundredYearsWar] Better Mob Combat not found, using default attack system");
        }
        checkPerformed = true;
    }

    public static boolean isBetterMobCombatLoaded() {
        return isBetterMobCombatLoaded;
    }

    public static boolean isActivated() {
        return BetterMobCombatIntegration.isBetterMobCombatLoaded() && ServerModConfig.INSTANCE.isEnableBetterMobCombat();
    }

    public static boolean isBetterCombatWeapon(ItemStack itemStack) {
        if (!isBetterMobCombatLoaded || itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        try {
            Object attributes = getAttributesMethod.invoke(null, itemStack);
            if (attributes == null) {
                return false;
            }
            Object attacks = attacksMethod.invoke(attributes, new Object[0]);
            if (attacks == null) {
                return false;
            }
            if (attacks instanceof Object[]) {
                Object[] attackArray = (Object[])attacks;
                return attackArray.length > 0;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean performBetterMobCombatAttack(BaseCombatEntity entity, LivingEntity target) {
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
            return false;
        }
        if (!isBetterMobCombatLoaded || !(entity instanceof Mob)) {
            return false;
        }
        ItemStack mainHandItem = entity.m_21205_();
        try {
            Object weaponAttributes = getAttributesMethod.invoke(null, mainHandItem);
            if (weaponAttributes == null) {
                return false;
            }
            Object attacks = attacksMethod.invoke(weaponAttributes, new Object[0]);
            if (attacks == null) {
                return false;
            }
            BiConsumer<Mob, Entity> damageApplicator = (mob, entityTarget) -> {
                if (!(entityTarget instanceof BaseCombatEntity) && !(entityTarget instanceof Player) || ServerRelationHelper.isEnemyRelation((Entity)mob, entityTarget)) {
                    mob.m_7327_(entityTarget);
                }
            };
            startUpswingMethod.invoke((Object)entity, weaponAttributes, damageApplicator);
            return true;
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Error during Better Mob Combat attack: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void ensureEntityFacesTarget(BaseCombatEntity entity, LivingEntity target) {
        double targetX = target.m_20185_();
        double targetY = target.m_20186_() + (double)target.m_20192_() * 0.75;
        double targetZ = target.m_20189_();
        entity.m_21563_().m_24950_(targetX, targetY, targetZ, 10.0f, 90.0f);
    }

    public static void resetComboCount(BaseCombatEntity entity) {
        try {
            Class<?> playerAttackPropertiesClass = Class.forName("net.bettercombat.logic.PlayerAttackProperties");
            if (playerAttackPropertiesClass.isInstance((Object)entity)) {
                Method setComboCountMethod = playerAttackPropertiesClass.getMethod("setComboCount", Integer.TYPE);
                setComboCountMethod.invoke((Object)entity, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isWithinBetterCombatRange(BaseCombatEntity entity, LivingEntity target) {
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat() || !isBetterMobCombatLoaded) {
            return BetterMobCombatIntegration.isWithinDefaultRange(entity, target);
        }
        if (!BetterMobCombatIntegration.isWithinDefaultRange(entity, target)) {
            return false;
        }
        try {
            Method attackMethod;
            Object attack;
            if (target != null) {
                BetterMobCombatIntegration.ensureEntityFacesTarget(entity, target);
            }
            Class<?> mobCombatHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper");
            Method isWithinAttackRangeMethod = mobCombatHelperClass.getMethod("isWithinAttackRange", LivingEntity.class, Entity.class, weaponAttributesAttackClass, Double.TYPE);
            Object attackHand = getCurrentAttackMethod.invoke(null, new Object[]{entity, 0});
            if (attackHand != null && (attack = (attackMethod = attackHandClass.getMethod("attack", new Class[0])).invoke(attackHand, new Object[0])) != null) {
                return (Boolean)isWithinAttackRangeMethod.invoke(null, new Object[]{entity, target, attack, Float.valueOf(entity.getAttackReach())});
            }
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Better Mob Combat range check failed: " + e.getMessage());
        }
        return true;
    }

    private static boolean isWithinDefaultRange(BaseCombatEntity entity, LivingEntity target) {
        float attackReach;
        double distanceSq = entity.m_20280_((Entity)target);
        return distanceSq <= (double)((attackReach = entity.getAttackReach()) * attackReach);
    }

    public static void disableSameEntityTypeCheck() {
        if (!isBetterMobCombatLoaded) {
            System.out.println("[HundredYearsWar] Better Mob Combat not loaded, cannot disable same entity type check");
            return;
        }
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
            return;
        }
        try {
            Object currentConfig = getServerConfigMethod.invoke(null, new Object[0]);
            if (currentConfig == null) {
                System.out.println("[HundredYearsWar] Failed to get Better Mob Combat server config");
                return;
            }
            boolean currentSameEntityTypeCheck = sameEntityTypeField.getBoolean(currentConfig);
            if (!currentSameEntityTypeCheck) {
                System.out.println("[HundredYearsWar] Better Mob Combat same entity type checks already disabled");
                return;
            }
            sameEntityTypeField.setBoolean(currentConfig, false);
            updateServerConfigMethod.invoke(null, currentConfig, true);
            System.out.println("[HundredYearsWar] Successfully disabled Better Mob Combat same entity type checks via runtime config modification");
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Failed to modify Better Mob Combat runtime config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        BetterMobCombatIntegration.checkAndLoadBetterMobCombat();
    }
}

