/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class FirstJoinHandler {
    private static final Set<UUID> firstJoinPlayers = new HashSet<UUID>();

    public static void handlePlayerFirstJoin(ServerPlayer player) {
        if (!ServerModConfig.INSTANCE.isEnableFirstJoinManual()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        if (firstJoinPlayers.add(playerUUID)) {
            ItemStack manual = new ItemStack((ItemLike)HywItemRegistry.CONQUERORS_MANUAL.get());
            if (!player.m_150109_().m_36054_(manual)) {
                player.m_36176_(manual, false);
            }
        }
    }

    public static void loadFirstJoinData(Path worldPath) {
        block9: {
            try {
                FirstJoinHandler.clearFirstJoinData();
                File file = worldPath.resolve("first_join_players.dat").toFile();
                if (!file.exists()) break block9;
                try (FileInputStream fis = new FileInputStream(file);){
                    CompoundTag tag = NbtIo.m_128939_((InputStream)fis);
                    if (tag.m_128441_("players")) {
                        int[] uuidArray = tag.m_128465_("players");
                        for (int i = 0; i < uuidArray.length; i += 4) {
                            if (i + 3 >= uuidArray.length) continue;
                            long mostSig = (long)uuidArray[i] << 32 | (long)uuidArray[i + 1] & 0xFFFFFFFFL;
                            long leastSig = (long)uuidArray[i + 2] << 32 | (long)uuidArray[i + 3] & 0xFFFFFFFFL;
                            UUID uuid = new UUID(mostSig, leastSig);
                            firstJoinPlayers.add(uuid);
                        }
                    }
                }
                System.out.println("\u5df2\u52a0\u8f7d " + firstJoinPlayers.size() + " \u4e2a\u9996\u6b21\u52a0\u5165\u73a9\u5bb6\u8bb0\u5f55");
            }
            catch (IOException e) {
                System.err.println("\u52a0\u8f7d\u9996\u6b21\u52a0\u5165\u73a9\u5bb6\u6570\u636e\u65f6\u51fa\u9519: " + e.getMessage());
            }
        }
    }

    public static void saveFirstJoinData(Path worldPath) {
        try {
            File file = worldPath.resolve("first_join_players.dat").toFile();
            CompoundTag tag = new CompoundTag();
            int[] uuidArray = new int[firstJoinPlayers.size() * 4];
            int index = 0;
            for (UUID uuid : firstJoinPlayers) {
                long mostSig = uuid.getMostSignificantBits();
                long leastSig = uuid.getLeastSignificantBits();
                uuidArray[index++] = (int)(mostSig >> 32);
                uuidArray[index++] = (int)mostSig;
                uuidArray[index++] = (int)(leastSig >> 32);
                uuidArray[index++] = (int)leastSig;
            }
            tag.m_128385_("players", uuidArray);
            try (FileOutputStream fos = new FileOutputStream(file);){
                NbtIo.m_128947_((CompoundTag)tag, (OutputStream)fos);
            }
            System.out.println("\u5df2\u4fdd\u5b58 " + firstJoinPlayers.size() + " \u4e2a\u9996\u6b21\u52a0\u5165\u73a9\u5bb6\u8bb0\u5f55");
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u9996\u6b21\u52a0\u5165\u73a9\u5bb6\u6570\u636e\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public static void clearFirstJoinData() {
        firstJoinPlayers.clear();
    }

    public static int getFirstJoinPlayerCount() {
        return firstJoinPlayers.size();
    }
}

