/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.GameType;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.BowPuppetEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.CrossbowPuppetEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.puppets.MeleePuppetEntity;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;

public class PuppetManager {
    private static final Map<UUID, WeaponSwapInfo> originalWeaponPositions = new HashMap<UUID, WeaponSwapInfo>();

    public static IPuppet createPuppetForPlayer(ServerPlayer player) {
        Entity entity;
        HywHorseEntity horse;
        IPuppet puppet;
        if (player.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return null;
        }
        IPuppet existingPuppet = PuppetManager.findPlayerPuppet(player);
        if (existingPuppet != null) {
            ((Entity)existingPuppet).m_146870_();
        }
        PuppetTypeAndWeapon result = PuppetManager.determinePuppetTypeAndSwapWeapon(player);
        PuppetType puppetType = result.puppetType;
        if (puppetType == null) {
            puppetType = PuppetType.MELEE;
        }
        Entity playerVehicle = null;
        if (player.m_20159_()) {
            playerVehicle = player.m_20202_();
            player.m_8127_();
        }
        if ((puppet = PuppetManager.createPuppetByType(puppetType, player)) == null) {
            return null;
        }
        Entity puppetEntity = (Entity)puppet;
        puppetEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        float headYaw = player.m_6080_();
        puppetEntity.m_146922_(headYaw);
        puppetEntity.m_146926_(player.m_146909_());
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity combatPuppet = (BaseCombatEntity)puppetEntity;
            combatPuppet.m_5616_(headYaw);
            combatPuppet.m_5618_(headYaw);
        }
        puppet.setOwnerUUID(player.m_20148_());
        PuppetManager.copyPlayerEquipmentToPuppet(player, puppet, puppetType);
        player.m_9236_().m_7967_(puppetEntity);
        if (playerVehicle != null) {
            puppetEntity.m_7998_(playerVehicle, true);
            if (playerVehicle instanceof HywHorseEntity) {
                horse = (HywHorseEntity)playerVehicle;
                puppetEntity.m_146922_(horse.m_146908_());
                puppetEntity.m_5618_(horse.m_146908_());
                puppetEntity.m_5616_(horse.m_146908_());
            }
        }
        player.m_7998_(puppetEntity, true);
        if (puppetEntity.m_20159_() && (entity = puppetEntity.m_20202_()) instanceof HywHorseEntity) {
            horse = (HywHorseEntity)entity;
            player.m_146922_(horse.m_146908_());
            player.m_5616_(horse.m_146908_());
        } else {
            player.m_146922_(puppetEntity.m_146908_());
            player.m_5616_(puppetEntity.m_146908_());
        }
        PuppetStateHandler.restorePuppetState(player, puppet);
        return puppet;
    }

    public static void removePuppetForPlayer(ServerPlayer player) {
        Entity vehicle;
        Entity puppetEntity;
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        float playerYRot = player.m_146908_();
        float playerXRot = player.m_146909_();
        IPuppet puppet = PuppetManager.findPlayerPuppet(player);
        Entity puppetVehicle = null;
        if (puppet != null) {
            PuppetStateHandler.savePuppetState(player, puppet);
        }
        if (puppet != null && (puppetEntity = (Entity)puppet).m_20159_()) {
            puppetVehicle = puppetEntity.m_20202_();
        }
        if (player.m_20159_() && (vehicle = player.m_20202_()) instanceof IPuppet) {
            player.m_8127_();
            player.m_6021_(playerX, playerY, playerZ);
            player.m_146922_(playerYRot);
            player.m_146926_(playerXRot);
        }
        if (puppet != null) {
            puppetEntity = (Entity)puppet;
            if (puppetEntity.m_20159_()) {
                puppetEntity.m_8127_();
            }
            puppetEntity.m_146870_();
            if (puppetVehicle != null && !puppetVehicle.m_213877_()) {
                player.m_7998_(puppetVehicle, true);
                if (puppetVehicle instanceof HywHorseEntity) {
                    HywHorseEntity horse = (HywHorseEntity)puppetVehicle;
                    player.m_146922_(horse.m_146908_());
                    player.m_5616_(horse.m_146908_());
                }
            }
        }
        PuppetManager.restoreOriginalWeapon(player);
    }

    private static PuppetTypeAndWeapon determinePuppetTypeAndSwapWeapon(ServerPlayer player) {
        ItemStack mainhandItem = player.m_21205_();
        PuppetType mainHandType = PuppetManager.getTypeForItem(mainhandItem);
        if (mainHandType != null) {
            return new PuppetTypeAndWeapon(mainHandType, null);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            PuppetType itemType = PuppetManager.getTypeForItem(stack);
            if (itemType == null) continue;
            PuppetManager.swapWeaponToMainHand(player, i, stack);
            return new PuppetTypeAndWeapon(itemType, stack);
        }
        return new PuppetTypeAndWeapon(null, null);
    }

    private static void swapWeaponToMainHand(ServerPlayer player, int weaponSlotIndex, ItemStack weapon) {
        ItemStack originalMainHand = player.m_21205_().m_41777_();
        originalWeaponPositions.put(player.m_20148_(), new WeaponSwapInfo(originalMainHand, weaponSlotIndex, weapon.m_41777_()));
        player.m_150109_().m_6836_(weaponSlotIndex, originalMainHand);
        player.m_21008_(InteractionHand.MAIN_HAND, weapon.m_41777_());
    }

    private static void restoreOriginalWeapon(ServerPlayer player) {
        WeaponSwapInfo swapInfo = originalWeaponPositions.remove(player.m_20148_());
        if (swapInfo != null) {
            ItemStack currentMainHand = player.m_21205_().m_41777_();
            player.m_150109_().m_6836_(swapInfo.weaponSlotIndex, currentMainHand);
            player.m_21008_(InteractionHand.MAIN_HAND, swapInfo.originalMainHand);
        }
    }

    private static PuppetType getTypeForItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SwordItem || item instanceof AxeItem) {
            return PuppetType.MELEE;
        }
        if (item instanceof BowItem) {
            return PuppetType.BOW;
        }
        if (item instanceof CrossbowItem) {
            return PuppetType.CROSSBOW;
        }
        return null;
    }

    private static IPuppet createPuppetByType(PuppetType type, ServerPlayer player) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PuppetType.MELEE -> (MeleePuppetEntity)((EntityType)HywEntityRegistry.MELEE_PUPPET.get()).m_20615_(player.m_9236_());
            case PuppetType.BOW -> (BowPuppetEntity)((EntityType)HywEntityRegistry.BOW_PUPPET.get()).m_20615_(player.m_9236_());
            case PuppetType.CROSSBOW -> (CrossbowPuppetEntity)((EntityType)HywEntityRegistry.CROSSBOW_PUPPET.get()).m_20615_(player.m_9236_());
        };
    }

    private static void copyPlayerEquipmentToPuppet(ServerPlayer player, IPuppet puppet, PuppetType puppetType) {
        ItemStack weaponToEquip;
        if (!(puppet instanceof BaseCombatEntity)) {
            return;
        }
        BaseCombatEntity combatEntity = (BaseCombatEntity)((Object)puppet);
        PuppetManager.copyArmorToPuppet(player, combatEntity);
        ItemStack offhandItem = player.m_21206_();
        if (!offhandItem.m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.OFFHAND, offhandItem.m_41777_());
        }
        switch (puppetType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MELEE: {
                ItemStack itemStack = PuppetManager.findMeleeWeaponForPlayer(player);
                break;
            }
            case BOW: {
                ItemStack itemStack = PuppetManager.findBowForPlayer(player);
                break;
            }
            case CROSSBOW: {
                ItemStack itemStack = weaponToEquip = PuppetManager.findCrossbowForPlayer(player);
            }
        }
        if (!weaponToEquip.m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.MAINHAND, weaponToEquip);
        } else if (puppetType == PuppetType.MELEE) {
            combatEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    private static void copyArmorToPuppet(ServerPlayer player, BaseCombatEntity combatEntity) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.HEAD, helmet.m_41777_());
        }
        if (!(chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.CHEST, chestplate.m_41777_());
        }
        if (!(leggings = player.m_6844_(EquipmentSlot.LEGS)).m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.LEGS, leggings.m_41777_());
        }
        if (!(boots = player.m_6844_(EquipmentSlot.FEET)).m_41619_()) {
            combatEntity.m_8061_(EquipmentSlot.FEET, boots.m_41777_());
        }
    }

    private static ItemStack findMeleeWeaponForPlayer(ServerPlayer player) {
        ItemStack mainhandItem = player.m_21205_();
        if (PuppetManager.isMeleeWeapon(mainhandItem)) {
            return mainhandItem.m_41777_();
        }
        return PuppetManager.findItemInInventory(player, PuppetManager::isMeleeWeapon);
    }

    private static ItemStack findBowForPlayer(ServerPlayer player) {
        ItemStack mainhandItem = player.m_21205_();
        if (mainhandItem.m_41720_() instanceof BowItem) {
            return mainhandItem.m_41777_();
        }
        return PuppetManager.findItemInInventory(player, stack -> stack.m_41720_() instanceof BowItem);
    }

    private static ItemStack findCrossbowForPlayer(ServerPlayer player) {
        ItemStack mainhandItem = player.m_21205_();
        if (mainhandItem.m_41720_() instanceof CrossbowItem) {
            return mainhandItem.m_41777_();
        }
        return PuppetManager.findItemInInventory(player, stack -> stack.m_41720_() instanceof CrossbowItem);
    }

    private static boolean isMeleeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof SwordItem || item instanceof AxeItem;
    }

    private static ItemStack findItemInInventory(ServerPlayer player, Predicate<ItemStack> predicate) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!predicate.test(stack)) continue;
            return stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static IPuppet findPlayerPuppet(ServerPlayer player) {
        List nearbyEntities = player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_(50.0), entity -> entity instanceof IPuppet);
        for (Entity entity2 : nearbyEntities) {
            if (!(entity2 instanceof IPuppet)) continue;
            IPuppet puppet = (IPuppet)entity2;
            if (!player.m_20148_().equals(puppet.getOwnerUUID())) continue;
            return puppet;
        }
        return null;
    }

    private static class PuppetTypeAndWeapon {
        public final PuppetType puppetType;
        public final ItemStack weapon;

        public PuppetTypeAndWeapon(PuppetType puppetType, ItemStack weapon) {
            this.puppetType = puppetType;
            this.weapon = weapon;
        }
    }

    public static enum PuppetType {
        MELEE,
        BOW,
        CROSSBOW;

    }

    private static class WeaponSwapInfo {
        public final ItemStack originalMainHand;
        public final int weaponSlotIndex;
        public final ItemStack weapon;

        public WeaponSwapInfo(ItemStack originalMainHand, int weaponSlotIndex, ItemStack weapon) {
            this.originalMainHand = originalMainHand;
            this.weaponSlotIndex = weaponSlotIndex;
            this.weapon = weapon;
        }
    }
}

