/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.PrioritizedGoal;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class PuppetStateHandler {
    private static final Map<UUID, PlayerPuppetState> savedPlayerStates = new ConcurrentHashMap<UUID, PlayerPuppetState>();
    private static final Map<UUID, PersistentPlayerState> persistentPlayerStates = new ConcurrentHashMap<UUID, PersistentPlayerState>();

    public static void savePuppetState(ServerPlayer player, IPuppet puppet) {
        if (puppet == null) {
            return;
        }
        Entity puppetEntity = (Entity)puppet;
        UUID playerUUID = player.m_20148_();
        UUID puppetUUID = puppetEntity.m_20148_();
        boolean wasSelected = false;
        SelectionSystem.Selection currentSelection = SelectionSystem.getSelection(player);
        if (currentSelection != null) {
            List<BaseCombatEntity> selectedEntities = currentSelection.getEntities();
            wasSelected = selectedEntities.stream().anyMatch(entity -> entity.m_20148_().equals(puppetUUID));
        }
        LinkedList<PrioritizedGoal> goalQueue = new LinkedList<PrioritizedGoal>();
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)puppetEntity;
            goalQueue.addAll(baseCombatEntity.getGoalQueue());
        }
        LivingEntity followTarget = null;
        ArrayList<BlockPos> patrolPoints = new ArrayList<BlockPos>();
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)puppetEntity;
            followTarget = baseCombatEntity.getFollowTarget();
            patrolPoints = new ArrayList<BlockPos>(baseCombatEntity.getPatrolPoints());
        }
        if (wasSelected || !goalQueue.isEmpty() || followTarget != null || !patrolPoints.isEmpty()) {
            PlayerPuppetState state = new PlayerPuppetState(wasSelected, goalQueue, followTarget, patrolPoints);
            savedPlayerStates.put(playerUUID, state);
        }
    }

    public static void restorePuppetState(ServerPlayer player, IPuppet newPuppet) {
        PersistentPlayerState persistentState;
        if (newPuppet == null) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        Entity newPuppetEntity = (Entity)newPuppet;
        PlayerPuppetState savedState = savedPlayerStates.remove(playerUUID);
        if (savedState != null) {
            SelectionSystem.Selection currentSelection;
            BaseCombatEntity baseCombatEntity;
            if (newPuppetEntity instanceof BaseCombatEntity) {
                baseCombatEntity = (BaseCombatEntity)newPuppetEntity;
                if (savedState.followTarget != null && !savedState.followTarget.m_213877_()) {
                    baseCombatEntity.setFollowTarget(savedState.followTarget);
                }
                if (!savedState.patrolPoints.isEmpty()) {
                    baseCombatEntity.clearPatrolPoints();
                    List<BlockPos> patrolPoints = baseCombatEntity.getPatrolPoints();
                    for (BlockPos pos : savedState.patrolPoints) {
                        patrolPoints.add(pos);
                    }
                }
            }
            if (savedState.wasSelected && (currentSelection = SelectionSystem.getSelection(player)) != null && newPuppetEntity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity2 = (BaseCombatEntity)newPuppetEntity;
                currentSelection.addEntity(baseCombatEntity2);
            }
            if (!savedState.goalQueue.isEmpty() && newPuppetEntity instanceof BaseCombatEntity) {
                baseCombatEntity = (BaseCombatEntity)newPuppetEntity;
                PuppetStateHandler.restoreGoalQueue(baseCombatEntity, savedState.goalQueue);
            }
        }
        if ((persistentState = persistentPlayerStates.get(playerUUID)) != null) {
            PuppetStateHandler.restoreSquadState(player, newPuppetEntity, persistentState.squadIndices);
        }
    }

    private static void restoreSquadState(ServerPlayer player, Entity newPuppetEntity, Set<Integer> squadIndices) {
        if (squadIndices.isEmpty() || !(newPuppetEntity instanceof BaseCombatEntity)) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        List playerSquads = SelectionSystem.getSquads().computeIfAbsent(playerUUID, k -> new ArrayList());
        for (Integer squadIndex : squadIndices) {
            ArrayList<Object> entityUUIDs;
            while (playerSquads.size() <= squadIndex) {
                playerSquads.add(null);
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadIndex);
            if (squad == null) {
                entityUUIDs = new ArrayList<UUID>();
                entityUUIDs.add(newPuppetEntity.m_20148_());
                squad = new SelectionSystem.Squad(entityUUIDs);
                playerSquads.set(squadIndex, squad);
                continue;
            }
            entityUUIDs = new ArrayList<UUID>(squad.getEntityUUIDs());
            if (entityUUIDs.contains(newPuppetEntity.m_20148_())) continue;
            entityUUIDs.add(newPuppetEntity.m_20148_());
            SelectionSystem.Squad updatedSquad = new SelectionSystem.Squad(entityUUIDs);
            playerSquads.set(squadIndex, updatedSquad);
        }
        SelectionSystem.getSquads().put(playerUUID, playerSquads);
    }

    private static void restoreGoalQueue(BaseCombatEntity baseCombatEntity, Queue<PrioritizedGoal> savedGoalQueue) {
        if (savedGoalQueue == null || savedGoalQueue.isEmpty()) {
            return;
        }
        baseCombatEntity.clearGoalQueue();
        LinkedList<PrioritizedGoal> updatedGoalQueue = new LinkedList<PrioritizedGoal>();
        for (PrioritizedGoal prioritizedGoal : savedGoalQueue) {
            Goal goal = prioritizedGoal.goal;
            if (goal instanceof CommandedGoal) {
                CommandedGoal commandedGoal = (CommandedGoal)goal;
                commandedGoal.updateEntityReference(baseCombatEntity);
            }
            updatedGoalQueue.add(prioritizedGoal);
        }
        baseCombatEntity.setGoalQueue(updatedGoalQueue);
        baseCombatEntity.executeNextGoal();
    }

    public static void clearPlayerState(UUID playerUUID) {
        savedPlayerStates.remove(playerUUID);
    }

    public static void clearAllTemporaryStates() {
        savedPlayerStates.clear();
    }

    public static void clearAllStates() {
        savedPlayerStates.clear();
        persistentPlayerStates.clear();
    }

    public static boolean hasSavedState(UUID playerUUID) {
        return savedPlayerStates.containsKey(playerUUID) || persistentPlayerStates.containsKey(playerUUID);
    }

    public static void savePersistentStates(Path savePath) throws IOException {
        CompoundTag nbt = new CompoundTag();
        ListTag stateList = new ListTag();
        for (Map.Entry<UUID, PersistentPlayerState> entry : persistentPlayerStates.entrySet()) {
            UUID playerUUID = entry.getKey();
            PersistentPlayerState state = entry.getValue();
            CompoundTag playerData = new CompoundTag();
            playerData.m_128362_("PlayerUUID", playerUUID);
            ListTag squadIndicesTag = new ListTag();
            for (Integer squadIndex : state.squadIndices) {
                squadIndicesTag.add((Object)StringTag.m_129297_((String)squadIndex.toString()));
            }
            playerData.m_128365_("SquadIndices", (Tag)squadIndicesTag);
            stateList.add((Object)playerData);
        }
        nbt.m_128365_("PlayerPuppetStates", (Tag)stateList);
        NbtIo.m_128944_((CompoundTag)nbt, (File)savePath.toFile());
    }

    public static void loadPersistentStates(Path savePath) throws IOException {
        if (!Files.exists(savePath, new LinkOption[0])) {
            return;
        }
        try {
            CompoundTag nbt = NbtIo.m_128937_((File)savePath.toFile());
            ListTag stateList = nbt.m_128437_("PlayerPuppetStates", 10);
            persistentPlayerStates.clear();
            for (int i = 0; i < stateList.size(); ++i) {
                CompoundTag playerData = stateList.m_128728_(i);
                UUID playerUUID = playerData.m_128342_("PlayerUUID");
                HashSet<Integer> squadIndices = new HashSet<Integer>();
                ListTag squadIndicesTag = playerData.m_128437_("SquadIndices", 8);
                for (int j = 0; j < squadIndicesTag.size(); ++j) {
                    squadIndices.add(Integer.parseInt(squadIndicesTag.m_128778_(j)));
                }
                PersistentPlayerState state = new PersistentPlayerState(squadIndices);
                persistentPlayerStates.put(playerUUID, state);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updatePuppetSquadState(UUID playerUUID, int squadIndex, List<UUID> entityUUIDs) {
        PersistentPlayerState currentState = persistentPlayerStates.get(playerUUID);
        HashSet<Integer> squadIndices = currentState != null ? new HashSet<Integer>(currentState.squadIndices) : new HashSet();
        squadIndices.add(squadIndex);
        PersistentPlayerState newState = new PersistentPlayerState(squadIndices);
        persistentPlayerStates.put(playerUUID, newState);
    }

    public static void removePuppetFromSquad(UUID playerUUID, int squadIndex) {
        PersistentPlayerState currentState = persistentPlayerStates.get(playerUUID);
        if (currentState != null) {
            HashSet<Integer> squadIndices = new HashSet<Integer>(currentState.squadIndices);
            squadIndices.remove(squadIndex);
            if (squadIndices.isEmpty()) {
                persistentPlayerStates.remove(playerUUID);
            } else {
                PersistentPlayerState newState = new PersistentPlayerState(squadIndices);
                persistentPlayerStates.put(playerUUID, newState);
            }
        }
    }

    public static void clearPuppetSquadState(UUID playerUUID, int squadIndex) {
        PuppetStateHandler.removePuppetFromSquad(playerUUID, squadIndex);
    }

    public static boolean isPuppetInSquad(UUID playerUUID, int squadIndex) {
        PersistentPlayerState state = persistentPlayerStates.get(playerUUID);
        return state != null && state.squadIndices.contains(squadIndex);
    }

    private static class PlayerPuppetState {
        public final boolean wasSelected;
        public final Queue<PrioritizedGoal> goalQueue;
        public final LivingEntity followTarget;
        public final List<BlockPos> patrolPoints;

        public PlayerPuppetState(boolean wasSelected, Queue<PrioritizedGoal> goalQueue, LivingEntity followTarget, List<BlockPos> patrolPoints) {
            this.wasSelected = wasSelected;
            this.goalQueue = new LinkedList<PrioritizedGoal>(goalQueue);
            this.followTarget = followTarget;
            this.patrolPoints = new ArrayList<BlockPos>(patrolPoints);
        }
    }

    private static class PersistentPlayerState {
        public final Set<Integer> squadIndices;

        public PersistentPlayerState(Set<Integer> squadIndices) {
            this.squadIndices = new HashSet<Integer>(squadIndices);
        }
    }
}

