/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam;

import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.config.ModBindings;
import ydmsama.hundred_years_war.client.freecam.mixins.MouseHandlerAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.ClientPuppetStateHandler;
import ydmsama.hundred_years_war.client.freecam.tripod.TripodRegistry;
import ydmsama.hundred_years_war.client.freecam.tripod.TripodSlot;
import ydmsama.hundred_years_war.client.freecam.util.FreeCamera;
import ydmsama.hundred_years_war.client.freecam.util.FreecamPosition;
import ydmsama.hundred_years_war.client.freecam.util.Motion;
import ydmsama.hundred_years_war.client.freecam.variant.api.BuildVariant;
import ydmsama.hundred_years_war.client.utils.ThirdPersonCompat;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.FreecamTogglePacket;

public class Freecam {
    public static final Minecraft MC = Minecraft.m_91087_();
    private static boolean rotateCamera = false;
    private static boolean shouldGrabMouse = false;
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static final TripodRegistry tripods = new TripodRegistry();
    private static TripodSlot activeTripod = TripodSlot.NONE;
    private static FreeCamera freeCamera;
    private static CameraType rememberedF5;
    private static double lastMouseX;
    private static double lastMouseY;
    private static int CamRollButtonHoldTicks;
    private static final int ROTATION_ACTIVATION_TICKS = 5;
    private static boolean rollRight;
    private static boolean rollLeft;
    private static boolean rollUp;
    private static boolean rollDown;
    private static boolean screenRoll;
    private static final int EDGE_THRESHOLD = 10;
    private static boolean isOnDisconnect;
    private static double speedMultiplier;

    public static void preTick(Minecraft mc) {
        if ((disableNextTick || Freecam.isRestrictedOnServer()) && Freecam.isEnabled()) {
            Freecam.toggle();
        }
        disableNextTick = false;
        if (Freecam.isEnabled()) {
            if (mc.f_91074_ != null) {
                if (!mc.f_91074_.m_6084_()) {
                    Freecam.toggle();
                    return;
                }
                if (mc.f_91074_.f_108618_ instanceof KeyboardInput && !Freecam.isPlayerControlEnabled()) {
                    Input input = new Input();
                    input.f_108573_ = mc.f_91074_.f_108618_.f_108573_;
                    mc.f_91074_.f_108618_ = input;
                }
            }
            mc.f_91063_.m_172736_(ClientModConfig.INSTANCE.visual.showHand);
            ClientPuppetStateHandler.checkAndRestorePuppetSelection();
        }
    }

    public static void postTick(Minecraft mc) {
        ModBindings.forEach(Tickable::m_7673_);
        if (CamRollButtonHoldTicks > 0 && ++CamRollButtonHoldTicks >= 5 && !Freecam.isRotateCamera()) {
            lastMouseX = Freecam.MC.f_91067_.m_91589_();
            lastMouseY = Freecam.MC.f_91067_.m_91594_();
            shouldGrabMouse = true;
            Freecam.MC.f_91067_.m_91601_();
            shouldGrabMouse = false;
            Freecam.activateRotateHandler();
        }
    }

    public static void onDisconnect() {
        isOnDisconnect = true;
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        tripods.clear();
        ClientPuppetStateHandler.clearAllStates();
    }

    public static boolean activateTripodHandler() {
        boolean activated = false;
        for (KeyMapping combo : Freecam.MC.f_91066_.f_92056_) {
            while (combo.m_90859_()) {
                Freecam.toggleTripod(TripodSlot.ofKeyCode(combo.m_90861_().m_84873_()));
                activated = true;
            }
        }
        return activated;
    }

    public static boolean resetTripodHandler() {
        boolean reset = false;
        for (KeyMapping key : Freecam.MC.f_91066_.f_92056_) {
            while (key.m_90859_()) {
                Freecam.resetCamera(TripodSlot.ofKeyCode(key.m_90861_().m_84873_()));
                reset = true;
            }
        }
        return reset;
    }

    public static void toggle() {
        if (Freecam.isRestrictedOnServer()) {
            if (ClientModConfig.INSTANCE.notification.notifyFreecam) {
                Freecam.MC.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.m_91089_().f_105363_}), true);
            }
            return;
        }
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        freecamEnabled = !freecamEnabled;
        isOnDisconnect = false;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(TripodSlot tripod) {
        if (tripod == TripodSlot.NONE) {
            return;
        }
        if (Freecam.isRestrictedOnServer()) {
            if (ClientModConfig.INSTANCE.notification.notifyTripod) {
                Freecam.MC.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.m_91089_().f_105363_}), true);
            }
            return;
        }
        if (tripodEnabled) {
            if (activeTripod == tripod) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(tripod);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(tripod);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        } else {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
            Freecam.freeCamera.f_108618_ = new Input();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(TripodSlot tripod) {
        Freecam.onEnable();
        FreecamPosition position = tripods.get(tripod);
        boolean chunkLoaded = false;
        if (position != null) {
            ChunkPos chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.f_91073_.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(tripod);
            position = null;
        }
        freeCamera = new FreeCamera(-420 - tripod.ordinal());
        if (position == null) {
            Freecam.moveToPlayer();
        } else {
            Freecam.moveToPosition(position);
        }
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        activeTripod = tripod;
        if (ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.freecam.openTripod", (Object[])new Object[]{tripod}), true);
        }
    }

    private static void onDisableTripod() {
        tripods.put(activeTripod, new FreecamPosition((Entity)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.freecam.closeTripod", (Object[])new Object[]{activeTripod}), true);
        }
        activeTripod = TripodSlot.NONE;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        Freecam.alignFreeCameraToCurrentView();
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        if (ClientModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.enable"), true);
        }
        Freecam.resetMouseButtons();
        Freecam.sendFreecamTogglePacket(true);
    }

    private static void onDisableFreecam() {
        ClientPuppetStateHandler.savePuppetSelectionState();
        if (!isOnDisconnect) {
            shouldGrabMouse = true;
            Freecam.MC.f_91067_.m_91601_();
            shouldGrabMouse = false;
        }
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ClientModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.disable"), true);
        }
        Freecam.sendFreecamTogglePacket(false);
    }

    private static void onEnable() {
        Freecam.MC.f_91063_.m_172736_(ClientModConfig.INSTANCE.visual.showHand);
        rememberedF5 = Freecam.MC.f_91066_.m_92176_();
        if (Freecam.MC.f_91063_.m_109153_().m_90594_()) {
            ThirdPersonCompat.killFadeIn();
            Freecam.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        Freecam.MC.f_91067_.m_91602_();
    }

    private static void onDisable() {
        Freecam.MC.f_91063_.m_172736_(true);
        MC.m_91118_((Entity)Freecam.MC.f_91074_);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.f_108618_ = new Input();
        freeCamera = null;
        if (Freecam.MC.f_91074_ != null) {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.f_91066_.m_92157_(rememberedF5);
        }
    }

    private static void resetCamera(TripodSlot tripod) {
        if (tripodEnabled && activeTripod != TripodSlot.NONE && activeTripod == tripod && freeCamera != null) {
            Freecam.moveToPlayer();
        } else {
            tripods.put(tripod, null);
        }
        if (ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237110_((String)"msg.freecam.tripodReset", (Object[])new Object[]{tripod}), true);
        }
    }

    public static void moveToEntity(@Nullable Entity entity) {
        if (freeCamera == null) {
            return;
        }
        if (entity == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.m_20359_(entity);
    }

    public static void moveToPosition(@Nullable FreecamPosition position) {
        if (freeCamera == null) {
            return;
        }
        if (position == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.applyPosition(position);
    }

    public static void moveToPlayer() {
        if (freeCamera == null) {
            return;
        }
        freeCamera.m_20359_((Entity)Freecam.MC.f_91074_);
        freeCamera.applyPerspective(ClientModConfig.Perspective.FIRST_PERSON, ClientModConfig.INSTANCE.collision.alwaysCheck || !ClientModConfig.INSTANCE.collision.ignoreAll || !BuildVariant.getInstance().cheatsPermitted());
    }

    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    public static void disableNextTick() {
        disableNextTick = true;
    }

    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    public static boolean isRestrictedOnServer() {
        ServerData server = MC.m_91089_();
        ClientModConfig.ServerRestriction mode = ClientModConfig.INSTANCE.servers.mode;
        if (mode == ClientModConfig.ServerRestriction.NONE || server == null || MC.m_257720_()) {
            return false;
        }
        String ip = server.f_105363_.trim().toLowerCase();
        return switch (mode) {
            case ClientModConfig.ServerRestriction.WHITELIST -> ClientModConfig.INSTANCE.servers.whitelist.stream().map(String::trim).map(String::toLowerCase).noneMatch(ip::equals);
            case ClientModConfig.ServerRestriction.BLACKLIST -> ClientModConfig.INSTANCE.servers.blacklist.stream().map(String::trim).map(String::toLowerCase).anyMatch(ip::equals);
            default -> throw new IllegalStateException("Unexpected mode value in Freecam.isRestrictedOnServer: " + mode);
        };
    }

    public static boolean isRotateCamera() {
        return rotateCamera;
    }

    public static void setRotateCamera(boolean rotate) {
        rotateCamera = rotate;
    }

    public static void activateRotateHandler() {
        Freecam.setRotateCamera(true);
    }

    public static void deactivateRotateHandler() {
        Freecam.setRotateCamera(false);
    }

    public static boolean getShouldGrabMouse() {
        return shouldGrabMouse;
    }

    public static void setShouldGrabMouse(boolean grabMouse) {
        shouldGrabMouse = grabMouse;
    }

    public static void doEdgeMotion() {
        double mouseX = Freecam.MC.f_91067_.m_91589_();
        double mouseY = Freecam.MC.f_91067_.m_91594_();
        int screenWidth = MC.m_91268_().m_85443_();
        int screenHeight = MC.m_91268_().m_85444_();
        if (Freecam.isEnabled()) {
            if (!rotateCamera) {
                boolean withinHorizontalBounds = mouseX >= 0.0 && mouseX <= (double)screenWidth;
                boolean withinVerticalBounds = mouseY >= 0.0 && mouseY <= (double)screenHeight;
                boolean nearRightEdge = withinHorizontalBounds && mouseX > (double)(screenWidth - 10);
                boolean nearLeftEdge = withinHorizontalBounds && mouseX < 10.0;
                boolean nearTopEdge = withinVerticalBounds && mouseY < 10.0;
                boolean nearBottomEdge = withinVerticalBounds && mouseY > (double)(screenHeight - 10);
                rollRight = nearRightEdge;
                rollLeft = nearLeftEdge;
                rollUp = nearTopEdge;
                rollDown = nearBottomEdge;
                screenRoll = nearRightEdge || nearLeftEdge || nearTopEdge || nearBottomEdge;
                Motion.doMotion(freeCamera, speedMultiplier * ClientModConfig.INSTANCE.movement.horizontalSpeed, speedMultiplier * ClientModConfig.INSTANCE.movement.verticalSpeed);
            } else {
                Motion.doMotion(freeCamera, speedMultiplier * ClientModConfig.INSTANCE.movement.horizontalSpeed, speedMultiplier * ClientModConfig.INSTANCE.movement.verticalSpeed);
            }
        }
    }

    public static boolean isScreenRoll() {
        return screenRoll;
    }

    public static boolean isRollRight() {
        return rollRight;
    }

    public static boolean isRollLeft() {
        return rollLeft;
    }

    public static boolean isRollUp() {
        return rollUp;
    }

    public static boolean isRollDown() {
        return rollDown;
    }

    public static double getLastMouseX() {
        return lastMouseX;
    }

    public static double getLastMouseY() {
        return lastMouseY;
    }

    public static void setLastMouseX(double lastMouseX) {
        Freecam.lastMouseX = lastMouseX;
    }

    public static void setLastMouseY(double lastMouseY) {
        Freecam.lastMouseY = lastMouseY;
    }

    public static int getCamRollButtonHoldTicks() {
        return CamRollButtonHoldTicks;
    }

    public static void setCamRollHoldTicks(int rightMouseHoldTicks) {
        CamRollButtonHoldTicks = rightMouseHoldTicks;
    }

    public static CameraType getRememberedF5() {
        return rememberedF5;
    }

    public static void resetMouseButtons() {
        MouseHandler mouseHandler = Minecraft.m_91087_().f_91067_;
        long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
        ((MouseHandlerAccessor)mouseHandler).callOnPress(windowHandle, 0, 0, 0);
        ((MouseHandlerAccessor)mouseHandler).callOnPress(windowHandle, 1, 0, 0);
    }

    public static double getSpeedMultiplier() {
        return speedMultiplier;
    }

    public static void setSpeedMultiplier(double speedMultiplier) {
        Freecam.speedMultiplier = speedMultiplier;
    }

    private static void alignFreeCameraToCurrentView() {
        freeCamera.syncToCamera(Freecam.MC.f_91063_.m_109153_());
    }

    private static void sendFreecamTogglePacket(boolean enabled) {
        if (MC.m_91403_() != null) {
            try {
                FreecamTogglePacket packet = new FreecamTogglePacket(enabled);
                ServerPacketHandler.sendToServer(packet);
            }
            catch (Exception e) {
                System.err.println("Failed to send freecam toggle packet: " + e.getMessage());
            }
        }
    }

    static {
        rememberedF5 = null;
        CamRollButtonHoldTicks = 0;
        rollRight = false;
        rollLeft = false;
        rollUp = false;
        rollDown = false;
        screenRoll = false;
        isOnDisconnect = false;
        speedMultiplier = 1.0;
    }
}

