/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract float m_21223_();

    @Inject(method={"getFrictionInfluencedSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetMovementSpeed(CallbackInfoReturnable<Float> cir) {
        if (Freecam.isEnabled() && ClientModConfig.INSTANCE.movement.flightMode.equals((Object)ClientModConfig.FlightMode.CREATIVE) && this.equals((Object)Freecam.getFreeCamera())) {
            cir.setReturnValue((Object)Float.valueOf((float)(ClientModConfig.INSTANCE.movement.horizontalSpeed / 10.0) * (float)(Freecam.getFreeCamera().m_20142_() ? 2 : 1)));
        }
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void onSetHealth(float health, CallbackInfo ci) {
        if (Freecam.isEnabled() && ClientModConfig.INSTANCE.utility.disableOnDamage && this.equals(Freecam.MC.f_91074_) && !Freecam.MC.f_91074_.m_7500_() && this.m_21223_() > health) {
            Freecam.disableNextTick();
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onDie(CallbackInfo ci) {
        if (!this.isClient()) {
            return;
        }
        Entity deadEntity = (Entity)this;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        selectionHandler.getSelectedEntities().remove(deadEntity);
        selectionHandler.getCombinedTargetMap().remove(deadEntity);
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = selectionHandler.getCombinedTargetMap();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            CopyOnWriteArraySet<TargetInfo> targetInfos = entry.getValue();
            targetInfos.removeIf(targetInfo -> deadEntity.equals((Object)targetInfo.getHywTarget()));
        }
        selectionHandler.getPatrolPointsMap().remove(deadEntity);
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.isClient()) {
            return;
        }
        Entity removedEntity = (Entity)this;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        selectionHandler.getSelectedEntities().remove(removedEntity);
        selectionHandler.getCombinedTargetMap().remove(removedEntity);
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = selectionHandler.getCombinedTargetMap();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            CopyOnWriteArraySet<TargetInfo> targetInfos = entry.getValue();
            targetInfos.removeIf(targetInfo -> removedEntity.equals((Object)targetInfo.getHywTarget()));
        }
        selectionHandler.getPatrolPointsMap().remove(removedEntity);
    }

    @Unique
    private boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }
}

