/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class ActionDisplayHandler {
    private static ActionDisplayHandler instance;
    private static final int PADDING = 5;
    private static final int ITEM_HEIGHT = 12;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;

    private ActionDisplayHandler() {
    }

    public static ActionDisplayHandler getInstance() {
        if (instance == null) {
            instance = new ActionDisplayHandler();
        }
        return instance;
    }

    private KeyMapping getKeyMappingById(String keyBindingId) {
        if (keyBindingId == null || keyBindingId.isEmpty()) {
            return null;
        }
        switch (keyBindingId) {
            case "key.hyw.attackCommand": {
                return HotKeyManager.getAttackCommandKey();
            }
            case "key.hyw.holdToggle": {
                return HotKeyManager.getHoldCommandKey();
            }
            case "key.hyw.patrolToggle": {
                return HotKeyManager.getPatrolToggleKey();
            }
            case "key.hyw.cancelCommand": {
                return HotKeyManager.getCancelCommandKey();
            }
            case "key.hyw.siegeModeToggle": {
                return HotKeyManager.getSiegeModeToggleKey();
            }
            case "key.hyw.bombardPosition": {
                return HotKeyManager.getBombardPositionKey();
            }
            case "key.hyw.unloadPassengers": {
                return HotKeyManager.getUnloadPassengersKey();
            }
        }
        return null;
    }

    private String getTranslationKey(String actionName) {
        return "action.hundred_years_war." + actionName.toLowerCase();
    }

    private Component getFormattedDescriptionComponent(Action action) {
        KeyMapping keyMapping = this.getKeyMappingById(action.getKeyBindingId());
        String keyName = keyMapping != null ? keyMapping.m_90863_().getString() : "";
        MutableComponent actionNameComponent = Component.m_237115_((String)this.getTranslationKey(action.getName()));
        if (action.isToggleAction()) {
            String stateKey = action.getCurrentState() ? "action.hundred_years_war.state.on" : "action.hundred_years_war.state.off";
            MutableComponent stateComponent = Component.m_237115_((String)stateKey).m_130940_(action.getCurrentState() ? ChatFormatting.GREEN : ChatFormatting.RED);
            return Component.m_237110_((String)"action.hundred_years_war.format.toggle", (Object[])new Object[]{actionNameComponent, keyName, stateComponent});
        }
        return Component.m_237110_((String)"action.hundred_years_war.format.basic", (Object[])new Object[]{actionNameComponent, keyName});
    }

    public void renderActionList(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        if (!selectionHandler.hasSelectedEntities()) {
            return;
        }
        List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
        List combatEntities = new ArrayList<Entity>(selectedEntities).stream().filter(entity -> entity instanceof BaseCombatEntity).map(entity -> (BaseCombatEntity)entity).collect(Collectors.toList());
        if (combatEntities.isEmpty()) {
            return;
        }
        LinkedHashMap actionsByType = new LinkedHashMap();
        if (!combatEntities.isEmpty()) {
            BaseCombatEntity firstEntity = (BaseCombatEntity)combatEntities.get(0);
            for (Action action : firstEntity.getActions()) {
                String actionClass = action.getClass().getName();
                actionsByType.put(actionClass, new ArrayList());
            }
        }
        for (Object entity2 : combatEntities) {
            for (Action action : ((BaseCombatEntity)entity2).getActions()) {
                String actionClass = action.getClass().getName();
                if (!actionsByType.containsKey(actionClass)) {
                    actionsByType.put(actionClass, new ArrayList());
                }
                ((List)actionsByType.get(actionClass)).add(action);
            }
        }
        ArrayList<Action> mergedActions = new ArrayList<Action>();
        for (Map.Entry entry : actionsByType.entrySet()) {
            List actions = (List)entry.getValue();
            if (actions.isEmpty()) continue;
            if (((Action)actions.get(0)).isToggleAction()) {
                int enabledCount = (int)actions.stream().filter(Action::getCurrentState).count();
                Action representative = (Action)actions.get(0);
                representative.setCurrentState(enabledCount > actions.size() / 2);
                mergedActions.add(representative);
                continue;
            }
            mergedActions.add((Action)actions.get(0));
        }
        int screenWidth = minecraft.m_91268_().m_85445_();
        int n = minecraft.m_91268_().m_85446_();
        int listWidth = 140;
        int listHeight = mergedActions.size() * 12 + 10;
        int startX = 5;
        int startY = n - listHeight - 5;
        Font font = minecraft.f_91062_;
        for (int i = 0; i < mergedActions.size(); ++i) {
            Action action = (Action)mergedActions.get(i);
            Component text = this.getFormattedDescriptionComponent(action);
            int textY = startY + 5 + i * 12;
            guiGraphics.m_280430_(font, text, startX + 5, textY, 0xFFFFFF);
        }
    }
}

