/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.lwjgl.glfw.GLFW;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

public class CustomCrosshairHandler {
    private static CustomCrosshairHandler instance;
    private static boolean isCursorHidden;
    private static final float CROSSHAIR_SIZE = 2.0f;
    private static final float CROSSHAIR_GAP = 0.4f;
    private static final int EXTRA_THICKNESS = 4;
    private static final float THICKNESS_OFFSET = 0.05f;
    private static final float MID_LINE_LENGTH = 1.2f;
    private static final float END_LINE_LENGTH = 2.4f;

    private CustomCrosshairHandler() {
    }

    public static CustomCrosshairHandler getInstance() {
        if (instance == null) {
            instance = new CustomCrosshairHandler();
        }
        return instance;
    }

    private static boolean shouldShowCustomCrosshair() {
        return !Objects.equals(HotKeyManager.getCurrentActive(), "") && !Freecam.isRotateCamera();
    }

    private static boolean shouldHideCursor() {
        if (Freecam.MC.f_91080_ != null) {
            return false;
        }
        return Freecam.isRotateCamera() || CustomCrosshairHandler.shouldShowCustomCrosshair();
    }

    private static void hideCursor() {
        GLFW.glfwSetInputMode((long)Freecam.MC.m_91268_().m_85439_(), (int)208897, (int)212994);
        isCursorHidden = true;
    }

    private static void showCursor() {
        GLFW.glfwSetInputMode((long)Freecam.MC.m_91268_().m_85439_(), (int)208897, (int)212993);
        isCursorHidden = false;
    }

    private static float[] getCrosshairColor() {
        float[] fArray;
        String currentActive;
        switch (currentActive = HotKeyManager.getCurrentActive()) {
            case "attack": {
                float[] fArray2 = new float[4];
                fArray2[0] = 1.0f;
                fArray2[1] = 0.2f;
                fArray2[2] = 0.2f;
                fArray = fArray2;
                fArray2[3] = 1.0f;
                break;
            }
            case "patrol": {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.2f;
                fArray3[1] = 0.2f;
                fArray3[2] = 1.0f;
                fArray = fArray3;
                fArray3[3] = 1.0f;
                break;
            }
            case "bombard": {
                float[] fArray4 = new float[4];
                fArray4[0] = 1.0f;
                fArray4[1] = 0.2f;
                fArray4[2] = 0.2f;
                fArray = fArray4;
                fArray4[3] = 1.0f;
                break;
            }
            case "unload": {
                float[] fArray5 = new float[4];
                fArray5[0] = 1.0f;
                fArray5[1] = 1.0f;
                fArray5[2] = 0.2f;
                fArray = fArray5;
                fArray5[3] = 1.0f;
                break;
            }
            default: {
                float[] fArray6 = new float[4];
                fArray6[0] = 1.0f;
                fArray6[1] = 1.0f;
                fArray6[2] = 1.0f;
                fArray = fArray6;
                fArray6[3] = 1.0f;
            }
        }
        return fArray;
    }

    public void renderCustomCrosshair(GuiGraphics guiGraphics) {
        if (Freecam.isRotateCamera()) {
            return;
        }
        boolean shouldShow = CustomCrosshairHandler.shouldShowCustomCrosshair();
        boolean shouldHide = CustomCrosshairHandler.shouldHideCursor();
        if (shouldHide) {
            CustomCrosshairHandler.hideCursor();
        } else {
            CustomCrosshairHandler.showCursor();
        }
        if (!shouldShow) {
            return;
        }
        int screenWidth = Freecam.MC.m_91268_().m_85443_();
        int screenHeight = Freecam.MC.m_91268_().m_85444_();
        int guiScreenWidth = Freecam.MC.m_91268_().m_85445_();
        int guiScreenHeight = Freecam.MC.m_91268_().m_85446_();
        double mouseX = Freecam.MC.f_91067_.m_91589_() / ((double)screenWidth / (double)guiScreenWidth);
        double mouseY = Freecam.MC.f_91067_.m_91594_() / ((double)screenHeight / (double)guiScreenHeight);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] color = CustomCrosshairHandler.getCrosshairColor();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        float a = color[3];
        CustomCrosshairHandler.drawCrosshairLines(mouseX, mouseY, r, g, b, a);
        RenderSystem.disableBlend();
    }

    private static void drawCrosshairLines(double mouseX, double mouseY, float r, float g, float b, float a) {
        CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, 0.0f, r, g, b, a);
        for (int thickness = 1; thickness <= 4; ++thickness) {
            float offset = (float)thickness * 0.05f;
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, offset, 0.0f, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, -offset, 0.0f, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, offset, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, -offset, r, g, b, a);
        }
    }

    private static void drawCrosshairAtOffset(double mouseX, double mouseY, float offsetX, float offsetY, float r, float g, float b, float a) {
        double x = mouseX + (double)offsetX;
        double y = mouseY + (double)offsetY;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(x - 2.0 - (double)0.4f, y, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - (double)0.4f, y, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + (double)0.4f, y, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + 2.0 + (double)0.4f, y, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x, y - 2.0 - (double)0.4f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x, y - (double)0.4f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x, y + (double)0.4f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x, y + 2.0 + (double)0.4f, 0.0).m_85950_(r, g, b, a).m_5752_();
        double midPos = 1.4000000059604645;
        bufferBuilder.m_5483_(x - midPos, y - (double)0.6f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - midPos, y + (double)0.6f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + midPos, y - (double)0.6f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + midPos, y + (double)0.6f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - (double)0.6f, y - midPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + (double)0.6f, y - midPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - (double)0.6f, y + midPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + (double)0.6f, y + midPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        double endPos = 2.4f;
        bufferBuilder.m_5483_(x - endPos, y - (double)1.2f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - endPos, y + (double)1.2f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + endPos, y - (double)1.2f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + endPos, y + (double)1.2f, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - (double)1.2f, y - endPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + (double)1.2f, y - endPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x - (double)1.2f, y + endPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(x + (double)1.2f, y + endPos, 0.0).m_85950_(r, g, b, a).m_5752_();
        tesselator.m_85914_();
    }

    static {
        isCursorHidden = false;
    }
}

