/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

public class HotKeyInfoHandler {
    private static HotKeyInfoHandler instance;
    private static final int PADDING = 2;
    private static final int ITEM_SPACING = 15;
    private static final float FONT_SCALE = 0.8f;

    private HotKeyInfoHandler() {
    }

    public static HotKeyInfoHandler getInstance() {
        if (instance == null) {
            instance = new HotKeyInfoHandler();
        }
        return instance;
    }

    private String formatKeyName(String keyName) {
        if (keyName.startsWith("key.")) {
            keyName = keyName.substring(4);
        }
        switch (keyName.toLowerCase()) {
            case "left_shift": 
            case "leftshift": {
                return "Shift";
            }
            case "left_control": 
            case "leftcontrol": {
                return "Ctrl";
            }
        }
        return keyName.toUpperCase();
    }

    private Component getQueueModeInfo() {
        String keyName = HotKeyManager.getQueueModeCommandKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return Component.m_237110_((String)"hud.hundred_years_war.hotkey.queue_mode", (Object[])new Object[]{formattedKeyName});
    }

    private Component getFormationModeInfo() {
        String keyName = HotKeyManager.getFormationToggleKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return Component.m_237110_((String)"hud.hundred_years_war.hotkey.formation_mode", (Object[])new Object[]{formattedKeyName});
    }

    private Component getTeamColorInfo() {
        String keyName = HotKeyManager.getTeamColorToggleKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return Component.m_237110_((String)"hud.hundred_years_war.hotkey.team_color", (Object[])new Object[]{formattedKeyName});
    }

    private void drawScaledString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(0.8f, 0.8f, 1.0f);
        guiGraphics.m_280430_(font, text, 0, 0, color);
        poseStack.m_85849_();
    }

    private int getScaledWidth(Font font, Component text) {
        return (int)((float)font.m_92852_((FormattedText)text) * 0.8f);
    }

    public void renderHotKeyInfo(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91062_;
        Component selectAllText = this.getSelectAllInfo();
        Component queueModeText = this.getQueueModeInfo();
        Component formationModeText = this.getFormationModeInfo();
        Component teamColorText = this.getTeamColorInfo();
        Component[] entries = new Component[]{selectAllText, queueModeText, formationModeText, teamColorText};
        int totalWidth = 0;
        int[] widths = new int[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            widths[i] = this.getScaledWidth(font, entries[i]);
            totalWidth += widths[i];
        }
        int startX = (screenWidth - (totalWidth += 15 * (entries.length - 1))) / 2;
        int y = screenHeight - 2 - 9;
        int currentX = startX;
        for (int i = 0; i < entries.length; ++i) {
            this.drawScaledString(guiGraphics, font, entries[i], currentX, y, 0xFFFFFF);
            currentX += widths[i] + 15;
        }
    }

    private Component getSelectAllInfo() {
        Component ctrl = HotKeyManager.getCtrlModeKey().m_90863_();
        Component select = HotKeyManager.getSelectAllUnitsKey().m_90863_();
        MutableComponent combo = Component.m_237119_().m_7220_(ctrl).m_7220_((Component)Component.m_237113_((String)"+")).m_7220_(select);
        return Component.m_237110_((String)"hud.hundred_years_war.hotkey.select_all", (Object[])new Object[]{combo});
    }
}

