/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.MemberDisplayListWidget;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

public class MemberDisplayListEntry
extends ContainerObjectSelectionList.Entry<MemberDisplayListEntry> {
    private final String playerName;
    private final UUID playerUUID;
    private final TeamMembersResponsePacket.Member.Role role;
    private final long joinTime;
    private final MemberDisplayListWidget parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private static final ResourceLocation PLAYER_ICON = new ResourceLocation("hundred_years_war", "textures/gui/player.png");
    private static final int ICON_SIZE = 16;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MemberDisplayListEntry(String playerName, UUID playerUUID, TeamMembersResponsePacket.Member.Role role, long joinTime, MemberDisplayListWidget parent) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.role = role;
        this.joinTime = joinTime;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public TeamMembersResponsePacket.Member.Role getRole() {
        return this.role;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        int nameColor;
        String currentPlayerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        boolean isSelf = this.playerName.equals(currentPlayerName);
        String roleSymbol = "";
        switch (this.role) {
            case OWNER: {
                nameColor = -22016;
                roleSymbol = " \u2605";
                break;
            }
            case ADMIN: {
                nameColor = -11162881;
                roleSymbol = " \u2699";
                break;
            }
            default: {
                nameColor = -1;
            }
        }
        Object displayName = this.playerName;
        if (isSelf) {
            displayName = "\u00a7l" + (String)displayName;
            guiGraphics.m_280509_(left + 2, top, left + width - 2, top + height, 503381760);
        }
        guiGraphics.m_280488_(this.minecraft.f_91062_, (String)displayName + roleSymbol, left + 10, top + 4, nameColor);
        Object roleText = switch (this.role) {
            case TeamMembersResponsePacket.Member.Role.OWNER -> this.minecraft.f_91062_.m_92718_() ? Component.m_237115_((String)"ui.hundred_years_war.team_owner").getString() : "(" + Component.m_237115_((String)"ui.hundred_years_war.team_owner").getString() + ")";
            case TeamMembersResponsePacket.Member.Role.ADMIN -> this.minecraft.f_91062_.m_92718_() ? Component.m_237115_((String)"ui.hundred_years_war.team_admin").getString() : "(" + Component.m_237115_((String)"ui.hundred_years_war.team_admin").getString() + ")";
            default -> this.minecraft.f_91062_.m_92718_() ? Component.m_237115_((String)"ui.hundred_years_war.team_member").getString() : "(" + Component.m_237115_((String)"ui.hundred_years_war.team_member").getString() + ")";
        };
        int roleColor = -5592406;
        guiGraphics.m_280488_(this.minecraft.f_91062_, (String)roleText, left + width - this.minecraft.f_91062_.m_92895_((String)roleText) - 10, top + 4, roleColor);
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return this.children.stream().filter(child -> child instanceof NarratableEntry).map(child -> (NarratableEntry)child).collect(Collectors.toList());
    }
}

