/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;

public class TeamCreateUI
extends Screen {
    private static final int WINDOW_WIDTH = 220;
    private static final int WINDOW_HEIGHT = 180;
    private final Screen parentScreen;
    private int leftPos;
    private int topPos;
    private EditBox teamNameField;
    private CustomButton createButton;
    private CustomButton cancelButton;
    private String errorMessage = "";
    private boolean isWaitingResponse = false;

    public TeamCreateUI(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_create_ui"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 220) / 2;
        this.topPos = (this.f_96544_ - 180) / 2;
        this.teamNameField = new EditBox(this.f_96547_, this.leftPos + 20, this.topPos + 20 + 30, 180, 20, (Component)Component.m_237113_((String)""));
        this.teamNameField.m_94199_(20);
        this.m_142416_((GuiEventListener)this.teamNameField);
        this.m_264313_((GuiEventListener)this.teamNameField);
        this.createButton = new CustomButton(this.leftPos + 110 - 60 - 5, this.topPos + 180 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.create"), button -> this.createTeam());
        this.m_142416_(this.createButton);
        this.cancelButton = new CustomButton(this.leftPos + 110 + 5, this.topPos + 180 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.cancel"), button -> this.m_7379_());
        this.m_142416_(this.cancelButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 220, this.topPos + 180, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 220, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 180 - 1, this.leftPos + 220, this.topPos + 180, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 180, -1);
        guiGraphics.m_280509_(this.leftPos + 220 - 1, this.topPos, this.leftPos + 220, this.topPos + 180, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 110, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_name"), this.leftPos + 20, this.topPos + 20 + 15, 0xFFFFFF);
        if (!this.errorMessage.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)this.errorMessage), this.leftPos + 110, this.topPos + 20 + 60, -43691);
        }
        if (this.isWaitingResponse) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.loading"), this.leftPos + 110, this.topPos + 20 + 60, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (!(keyCode != 257 && keyCode != 335 || this.isWaitingResponse)) {
            this.createTeam();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void createTeam() {
        String teamName = this.teamNameField.m_94155_().trim();
        if (teamName.isEmpty()) {
            this.errorMessage = "message.hundred_years_war.team_name_empty";
            return;
        }
        if (teamName.length() < 3) {
            this.errorMessage = "message.hundred_years_war.team_name_too_short";
            return;
        }
        if (teamName.length() > 20) {
            this.errorMessage = "message.hundred_years_war.team_name_too_long";
            return;
        }
        this.isWaitingResponse = true;
        this.createButton.f_93623_ = false;
        this.errorMessage = "";
        ClientPacketHandler.requestCreateTeam(teamName);
    }

    public void onTeamCreateResponse(TeamCreateResponsePacket packet) {
        this.isWaitingResponse = false;
        this.createButton.f_93623_ = true;
        if (packet.isSuccess()) {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
        } else {
            this.errorMessage = "message.hundred_years_war." + packet.getMessage();
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }
}

