/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.MemberDisplayListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.MemberDisplayListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

public class TeamInfoUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final Screen parentScreen;
    private final UUID teamUUID;
    private String teamName;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private MemberDisplayListWidget memberListWidget;
    private CustomButton backButton;
    private String searchText = "";
    private List<TeamMembersResponsePacket.Member> allMembers = new ArrayList<TeamMembersResponsePacket.Member>();
    private List<TeamMembersResponsePacket.Member> filteredMembers = new ArrayList<TeamMembersResponsePacket.Member>();
    private long lastRequestTime = 0L;
    private static final long REQUEST_INTERVAL = 1000L;

    public TeamInfoUI(Screen parentScreen, UUID teamUUID, String teamName) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_info_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        ClientPacketHandler.requestTeamMembers(teamUUID);
    }

    public void onMembersDataUpdate(TeamMembersResponsePacket packet) {
        if (!packet.getTeamUUID().equals(this.teamUUID)) {
            return;
        }
        this.allMembers.clear();
        this.teamName = packet.getTeamName();
        this.allMembers.addAll(packet.getMembers());
        System.out.println("\u6536\u5230\u56e2\u961f\u6210\u5458\u6570\u636e: " + packet.getTeamName() + ", \u6210\u5458\u6570\u91cf: " + this.allMembers.size());
        for (TeamMembersResponsePacket.Member member : this.allMembers) {
            System.out.println("\u6210\u5458: " + member.getPlayerName() + ", \u89d2\u8272: " + member.getRole());
        }
        if (this.searchBox != null && this.memberListWidget != null) {
            this.updateFilteredMembers();
            this.memberListWidget.m_93410_(0.0);
        }
    }

    private void updateFilteredMembers() {
        if (this.searchBox == null) {
            return;
        }
        String searchText = this.searchBox.m_94155_().toLowerCase();
        this.filteredMembers.clear();
        if (searchText.isEmpty()) {
            this.filteredMembers.addAll(this.allMembers);
        } else {
            for (TeamMembersResponsePacket.Member member : this.allMembers) {
                if (!member.getPlayerName().toLowerCase().contains(searchText)) continue;
                this.filteredMembers.add(member);
            }
        }
        this.updateMemberList();
    }

    private void updateMemberList() {
        if (this.memberListWidget == null) {
            return;
        }
        this.memberListWidget.m_93516_();
        for (TeamMembersResponsePacket.Member member : this.filteredMembers) {
            MemberDisplayListEntry entry = new MemberDisplayListEntry(member.getPlayerName(), member.getPlayerUUID(), member.getRole(), member.getJoinTime(), this.memberListWidget);
            this.memberListWidget.addEntry(entry);
        }
        this.memberListWidget.m_93410_(0.0);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            this.updateFilteredMembers();
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            this.updateFilteredMembers();
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.searchBox.m_93696_()) {
            return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(32);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94190_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_94151_(s -> {
            this.searchText = s;
            this.updateFilteredMembers();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        this.memberListWidget = new MemberDisplayListWidget(this.f_96541_, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.memberListWidget.m_93507_(this.leftPos + 20);
        this.m_142416_((GuiEventListener)this.memberListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_());
        this.m_142416_(this.backButton);
        this.allMembers.clear();
        this.filteredMembers.clear();
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
        TeamMembersResponsePacket latestData = ClientPacketHandler.getLatestTeamMembersData();
        if (latestData != null && latestData.getTeamUUID().equals(this.teamUUID)) {
            this.onMembersDataUpdate(latestData);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.teamName), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        if (this.allMembers.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRequestTime > 1000L) {
                this.requestMembersData();
                this.lastRequestTime = currentTime;
            }
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.loading"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        } else if (this.filteredMembers.isEmpty() && !this.searchText.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_members_found"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void requestMembersData() {
        System.out.println("\u8bf7\u6c42\u56e2\u961f\u6210\u5458\u6570\u636e\uff0cteamUUID: " + this.teamUUID);
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }
}

