/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.TeamListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.TeamListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class TeamJoinUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private static final int SEARCH_BOX_HEIGHT = 20;
    private static final int TEAM_ITEM_HEIGHT = 24;
    private static final int TEAM_LIST_HEIGHT = 150;
    private final Screen parentScreen;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private TeamListWidget teamListWidget;
    private CustomButton cancelButton;
    private String errorMessage = "";
    private String searchText = "";
    private List<TeamInfo> allTeams = new ArrayList<TeamInfo>();
    private List<TeamInfo> filteredTeams = new ArrayList<TeamInfo>();

    public TeamJoinUI(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_join_ui"));
        this.parentScreen = parentScreen;
        ClientPacketHandler.requestTeamList();
    }

    public void onTeamListUpdate(TeamListResponsePacket packet) {
        System.out.println("TeamJoinUI\u6536\u5230\u56e2\u961f\u5217\u8868\u6570\u636e\u5305\uff0c\u56e2\u961f\u6570\u91cf: " + packet.getTeams().size());
        this.allTeams.clear();
        for (Map.Entry<UUID, TeamListResponsePacket.TeamInfo> entry : packet.getTeams().entrySet()) {
            UUID teamUUID = entry.getKey();
            TeamListResponsePacket.TeamInfo teamInfo = entry.getValue();
            this.allTeams.add(new TeamInfo(teamUUID, teamInfo.getTeamName(), teamInfo.getMemberCount(), teamInfo.getOwnerName(), teamInfo.getRelation()));
        }
        if (this.searchBox != null && this.teamListWidget != null) {
            this.updateFilteredTeams();
            this.teamListWidget.m_93410_(0.0);
        }
    }

    private void updateFilteredTeams() {
        if (this.searchBox == null) {
            System.out.println("\u8b66\u544a: updateFilteredTeams() \u88ab\u8c03\u7528\u4f46searchBox\u4e3a\u7a7a");
            return;
        }
        String searchText = this.searchBox.m_94155_().toLowerCase();
        System.out.println("\u66f4\u65b0\u8fc7\u6ee4\u56e2\u961f\u5217\u8868: \u641c\u7d22\u6587\u672c=" + searchText + ", \u5f53\u524d\u6240\u6709\u56e2\u961f\u6570\u91cf=" + this.allTeams.size());
        this.filteredTeams.clear();
        if (searchText.isEmpty()) {
            this.filteredTeams.addAll(this.allTeams);
        } else {
            for (TeamInfo team : this.allTeams) {
                if (!team.teamName.toLowerCase().contains(searchText)) continue;
                this.filteredTeams.add(team);
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u56e2\u961f\u6570\u91cf: " + this.filteredTeams.size());
        this.updateTeamList();
    }

    private void updateTeamList() {
        if (this.teamListWidget == null) {
            return;
        }
        this.teamListWidget.m_93516_();
        for (TeamInfo team : this.filteredTeams) {
            TeamListEntry entry = new TeamListEntry(team.teamName, team.teamUUID, this.teamListWidget);
            entry.setButtonText((Component)Component.m_237115_((String)"button.hundred_years_war.join"));
            entry.setButtonClickHandler(() -> this.joinTeam(team.teamUUID));
            this.teamListWidget.addEntry(entry);
        }
        this.teamListWidget.m_93410_(0.0);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            this.updateFilteredTeams();
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            this.updateFilteredTeams();
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20 + 15, 220, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_94151_(this::onSearchTextChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int teamListTop = this.topPos + 20 + 15 + 20 + 5;
        this.teamListWidget = new TeamListWidget(this.f_96541_, 220, 150, teamListTop, teamListTop + 150, 24);
        this.teamListWidget.m_93507_(this.leftPos + 10);
        this.m_7787_((GuiEventListener)this.teamListWidget);
        this.cancelButton = new CustomButton(this.leftPos + 120 - 40, this.topPos + 250 - 20 - 20, 80, 20, (Component)Component.m_237115_((String)"button.hundred_years_war.cancel"), button -> this.m_7379_());
        this.m_142416_(this.cancelButton);
        this.allTeams.clear();
        this.filteredTeams.clear();
        ClientPacketHandler.requestTeamList();
        System.out.println("TeamJoinUI.init: \u8bf7\u6c42\u56e2\u961f\u5217\u8868\u6570\u636e");
        TeamListResponsePacket latestData = ClientPacketHandler.getLatestTeamListData();
        if (latestData != null) {
            System.out.println("TeamJoinUI.init: \u4f7f\u7528\u5df2\u6709\u7684\u56e2\u961f\u5217\u8868\u6570\u636e");
            this.onTeamListUpdate(latestData);
        }
        if (this.allTeams.isEmpty()) {
            System.out.println("TeamJoinUI.init: \u6dfb\u52a0\u6a21\u62df\u6570\u636e");
            this.addMockTeams();
        }
        if (this.filteredTeams.isEmpty() && !this.allTeams.isEmpty()) {
            this.filteredTeams.addAll(this.allTeams);
            this.updateTeamList();
        }
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.updateFilteredTeams();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 1, this.leftPos + 1, this.topPos + 250 - 1, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos + 1, this.leftPos + 240, this.topPos + 250 - 1, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.search_team"), this.leftPos + 10, this.topPos + 20, 0xFFFFFF);
        if (!this.errorMessage.isEmpty()) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.errorMessage), this.leftPos + 10, this.topPos + 250 - 20 - 10, 0xFF5555);
        }
        if (this.filteredTeams.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_teams_found"), this.leftPos + 120, this.topPos + 20 + 15 + 20 + 75, 0xBBBBBB);
        }
        this.teamListWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void joinTeam(UUID teamUUID) {
        try {
            ClientPacketHandler.requestJoinTeam(teamUUID);
            Minecraft.m_91087_().m_91152_(this.parentScreen);
        }
        catch (Exception e) {
            this.errorMessage = "\u65e0\u6cd5\u53d1\u9001\u56e2\u961f\u52a0\u5165\u8bf7\u6c42: " + e.getMessage();
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    private void addMockTeams() {
        System.out.println("\u6dfb\u52a0\u6a21\u62df\u56e2\u961f\u6570\u636e");
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u82f1\u683c\u5170\u9a91\u58eb\u56e2", 5, "\u56fd\u738b\u4ea8\u5229\u4e94\u4e16", RelationSystem.RelationType.NEUTRAL));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u6cd5\u56fd\u7981\u536b\u519b", 7, "\u56fd\u738b\u67e5\u7406\u516d\u4e16", RelationSystem.RelationType.HOSTILE));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u82cf\u683c\u5170\u9ad8\u5730\u519b", 3, "\u7f57\u4f2f\u7279\u4e00\u4e16", RelationSystem.RelationType.FRIENDLY));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u52c3\u826e\u7b2c\u96c7\u4f63\u5175", 9, "\u52c7\u6562\u7684\u67e5\u7406", RelationSystem.RelationType.NEUTRAL));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u610f\u5927\u5229\u5f13\u7bad\u624b", 6, "\u795e\u5723\u7f57\u9a6c\u7687\u5e1d", RelationSystem.RelationType.NEUTRAL));
        this.filteredTeams.clear();
        this.filteredTeams.addAll(this.allTeams);
        if (this.searchBox != null && this.teamListWidget != null) {
            this.updateTeamList();
        }
        System.out.println("\u6dfb\u52a0\u5b8c\u6a21\u62df\u6570\u636e\u540e\uff0c\u56e2\u961f\u603b\u6570: " + this.allTeams.size());
    }

    public static class TeamInfo {
        private final UUID teamUUID;
        private final String teamName;
        private final int memberCount;
        private final String ownerName;
        private final RelationSystem.RelationType relation;

        public TeamInfo(UUID teamUUID, String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
            this.teamUUID = teamUUID;
            this.teamName = teamName;
            this.memberCount = memberCount;
            this.ownerName = ownerName;
            this.relation = relation;
        }

        public UUID getTeamUUID() {
            return this.teamUUID;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public RelationSystem.RelationType getRelation() {
            return this.relation;
        }
    }
}

