/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationUI;

public class TeamRelationListWidget
extends ContainerObjectSelectionList<TeamRelationListEntry> {
    private final TeamRelationUI parent;
    private final Map<UUID, List<Integer>> teamEntriesMap = new HashMap<UUID, List<Integer>>();
    private final Map<Integer, UUID> entryTeamMap = new HashMap<Integer, UUID>();
    private final Set<UUID> teamUUIDs = new HashSet<UUID>();

    public TeamRelationListWidget(TeamRelationUI parent, Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.parent = parent;
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.f_93393_, this.f_93390_, this.f_93393_ + this.f_93388_, this.f_93391_, Integer.MIN_VALUE);
        this.renderTeamDividers(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderTeamDividers(GuiGraphics guiGraphics) {
        int y0 = (int)this.m_93517_();
        int y1 = y0 + this.f_93389_;
        for (UUID teamUUID : this.teamUUIDs) {
            List<Integer> memberIndices = this.teamEntriesMap.get(teamUUID);
            if (memberIndices == null) continue;
            int teamIndex = -1;
            for (int i = 0; i < this.m_6702_().size(); ++i) {
                TeamRelationListEntry entry = (TeamRelationListEntry)((Object)this.m_6702_().get(i));
                if (entry.getEntryType() != TeamRelationListEntry.EntryType.TEAM || !entry.getPlayerUUID().equals(teamUUID)) continue;
                teamIndex = i;
                break;
            }
            if (teamIndex == -1) continue;
            int topDividerY = this.f_93390_ + teamIndex * this.f_93387_ - y0 + 4;
            int lastMemberIndex = -1;
            for (int index : memberIndices) {
                if (index <= lastMemberIndex) continue;
                lastMemberIndex = index;
            }
            if (topDividerY < this.f_93390_ || topDividerY > this.f_93391_) continue;
            for (int i = 0; i < 2; ++i) {
                int alpha = 180 - i * 80;
                guiGraphics.m_280509_(this.f_93393_, topDividerY - i, this.f_93393_ + this.f_93388_, topDividerY - i + 1, alpha << 24 | 0xBBBBBB);
            }
        }
    }

    public void clearAllEntries() {
        super.m_93516_();
        this.teamEntriesMap.clear();
        this.entryTeamMap.clear();
        this.teamUUIDs.clear();
    }

    public int addEntry(TeamRelationListEntry entry) {
        int index = this.m_6702_().size();
        super.m_7085_((AbstractSelectionList.Entry)entry);
        if (entry.getEntryType() == TeamRelationListEntry.EntryType.TEAM) {
            UUID teamUUID = entry.getPlayerUUID();
            this.teamUUIDs.add(teamUUID);
            this.teamEntriesMap.computeIfAbsent(teamUUID, k -> new ArrayList());
        }
        return index;
    }

    public void markAsMember(int memberIndex, UUID teamUUID) {
        if (this.teamUUIDs.contains(teamUUID)) {
            this.teamEntriesMap.computeIfAbsent(teamUUID, k -> new ArrayList()).add(memberIndex);
            this.entryTeamMap.put(memberIndex, teamUUID);
        }
    }

    public void setTeamMembers(UUID teamUUID, List<Integer> memberIndices) {
        if (this.teamUUIDs.contains(teamUUID)) {
            this.teamEntriesMap.put(teamUUID, new ArrayList<Integer>(memberIndices));
            for (int index : memberIndices) {
                this.entryTeamMap.put(index, teamUUID);
            }
        }
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY >= (double)this.f_93390_ && mouseY <= (double)this.f_93391_ && mouseX >= (double)this.f_93393_ && mouseX <= (double)this.f_93392_;
    }
}

