/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.client.freecam.ui.CustomUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamCreateUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamInfoUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamJoinUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamManageUI;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;

public class TeamUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private int leftPos;
    private int topPos;
    private boolean isLoading = true;
    private boolean isInTeam = false;
    private String teamName = "";
    private UUID teamUUID = null;
    private String teamOwnerName = "";
    private List<String> teamMembers = new ArrayList<String>();
    private List<String> teamAdmins = new ArrayList<String>();
    private List<String> pendingApplications = new ArrayList<String>();
    private CustomButton createTeamButton;
    private CustomButton joinTeamButton;
    private CustomButton manageTeamButton;
    private CustomButton teamInfoButton;
    private CustomButton leaveTeamButton;
    private CustomButton backButton;

    public TeamUI() {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.teams_ui"));
        this.requestTeamData();
    }

    private void requestTeamData() {
        this.isLoading = true;
        ClientPacketHandler.requestTeamData();
    }

    public void onTeamDataUpdate(TeamInfoResponsePacket packet) {
        this.isLoading = false;
        this.isInTeam = packet.isInTeam();
        if (this.isInTeam) {
            this.teamName = packet.getTeamName();
            this.teamUUID = packet.getTeamUUID();
            this.teamOwnerName = packet.getTeamOwnerName();
            this.teamMembers = packet.getTeamMembers();
            this.teamAdmins = packet.getTeamAdmins();
            this.pendingApplications = packet.getPendingApplications();
        }
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.m_169413_();
        if (this.isLoading) {
            this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_());
            this.m_142416_(this.backButton);
            return;
        }
        if (this.isInTeam) {
            this.teamInfoButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30, 120, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_info"), button -> this.openTeamInfoUI());
            this.m_142416_(this.teamInfoButton);
            if (this.teamOwnerName.equals(this.f_96541_.f_91074_.m_7755_().getString()) || this.teamAdmins.contains(this.f_96541_.f_91074_.m_7755_().getString())) {
                this.manageTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30 + 20 + 10, 120, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_manage"), button -> this.manageTeam());
                this.m_142416_(this.manageTeamButton);
            }
            this.leaveTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 250 - 40 - 10 - 5, 120, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_leave"), button -> this.leaveTeam());
            this.leaveTeamButton.setColor(-5636096, -3407872, -11206656);
            this.m_142416_(this.leaveTeamButton);
        } else {
            this.createTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30, 120, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_create"), button -> this.createTeam());
            this.m_142416_(this.createTeamButton);
            this.joinTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30 + 20 + 10, 120, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.team_join"), button -> this.joinTeam());
            this.m_142416_(this.joinTeamButton);
        }
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_());
        this.m_142416_(this.backButton);
    }

    private void openTeamInfoUI() {
        System.out.println("\u6253\u5f00\u56e2\u961f\u4fe1\u606fUI: teamUUID=" + this.teamUUID + ", teamName=" + this.teamName);
        if (this.teamUUID == null) {
            System.out.println("\u9519\u8bef: \u56e2\u961fUUID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5f00\u56e2\u961f\u4fe1\u606fUI");
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new TeamInfoUI(this, this.teamUUID, this.teamName));
    }

    private void manageTeam() {
        Minecraft.m_91087_().m_91152_((Screen)new TeamManageUI(this, this.teamUUID, this.teamName, this.teamOwnerName, this.teamMembers, this.teamAdmins, this.pendingApplications));
    }

    private void leaveTeam() {
        this.f_96541_.m_91152_((Screen)new CustomConfirmScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.confirm"), (Component)Component.m_237115_((String)"ui.hundred_years_war.leave_team_confirm"), confirmed -> {
            if (confirmed) {
                ClientPacketHandler.requestLeaveTeam(this.teamUUID);
                this.requestTeamData();
            } else {
                Minecraft.m_91087_().m_91152_((Screen)this);
            }
        }));
    }

    private void createTeam() {
        Minecraft.m_91087_().m_91152_((Screen)new TeamCreateUI(this));
    }

    private void joinTeam() {
        Minecraft.m_91087_().m_91152_((Screen)new TeamJoinUI(this));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.isLoading) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.loading"), this.leftPos + 120, this.topPos + 125 - 10, 0xFFFFFF);
        } else if (this.isInTeam) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.teamName), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        } else {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_team"), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)new CustomUI());
    }
}

