/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelNode;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelTree;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.TrapezoidButton;

public class CommandWheelUI
extends Screen {
    private final List<TrapezoidButton> buttons = new ArrayList<TrapezoidButton>();
    private final CommandWheelTree tree = new CommandWheelTree();
    private String lastAttackState = "";
    private int currentPage = 0;
    private static final int SEGMENT = 8;
    private static final int ITEMS_PER_PAGE = 8;
    private static final float INNER = 40.0f;
    private static final float OUTER = 120.0f;
    private static final float PAGINATION_BUTTON_INNER_RADIUS = 5.0f;
    private static final float PAGINATION_BUTTON_OUTER_RADIUS = 20.0f;
    private static final float PAGINATION_BUTTON_ANGLE_SPAN = 40.0f;
    private static final float PAGINATION_BUTTON_Y_OFFSET = 15.0f;
    private static final float PAGINATION_TEXT_Y_OFFSET = 15.0f;
    private static final int PAGINATION_TEXT_COLOR = 0xFFFFFF;
    private static final int PAGINATION_CUSTOM_BUTTON_WIDTH = 15;
    private static final int PAGINATION_CUSTOM_BUTTON_HEIGHT = 10;
    private static final int PAGINATION_BUTTON_SPACING = 15;
    private static final int PAGINATION_TEXT_HORIZONTAL_OFFSET = 0;

    public CommandWheelUI() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        CommandWheelNode attackNode;
        this.m_169413_();
        this.buttons.clear();
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        float segDeg = 45.0f;
        this.tree.updateDynamicNodes();
        List<CommandWheelNode> allNodesInCurrentLevel = this.tree.getCurrentNode().getChildren();
        int totalNodesInLevel = allNodesInCurrentLevel.size();
        int totalPages = this.tree.getTotalPages(8);
        if (this.currentPage >= totalPages && totalPages > 0) {
            this.currentPage = totalPages - 1;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        List<CommandWheelNode> nodesToShow = this.tree.getCurrentPageNodes(this.currentPage, 8);
        int emptyButtonsNeeded = 8 - nodesToShow.size();
        for (int i = 0; i < 8; ++i) {
            float a1;
            float a0 = (float)i * segDeg - 90.0f;
            if (a0 < 0.0f) {
                a0 += 360.0f;
            }
            if ((a1 = a0 + segDeg) >= 360.0f) {
                a1 -= 360.0f;
            }
            if (i < nodesToShow.size()) {
                MutableComponent label;
                CommandWheelNode node = nodesToShow.get(i);
                String titleKey = node.getTitleKey();
                if ("wheel.hundred_years_war.formation".equals(titleKey) && this.tree.getCurrentNode() == this.tree.getRoot() && node.isDynamic() && node.getState() != null) {
                    label = Component.m_237110_((String)"wheel.hundred_years_war.formation.current", (Object[])new Object[]{Component.m_237115_((String)("wheel.hundred_years_war.formation." + node.getState())).getString()});
                } else if ("wheel.hundred_years_war.recruitment_config".equals(titleKey) && this.tree.getCurrentNode() == this.tree.getRoot() && node.isDynamic() && node.getState() != null) {
                    MutableComponent stateComponent = Component.m_237115_((String)node.getState());
                    label = Component.m_237110_((String)"wheel.hundred_years_war.recruitment_config", (Object[])new Object[]{stateComponent.getString()});
                } else if (titleKey.startsWith("army.hundred_years_war.") && node.isDynamic() && node.getState() != null) {
                    String baseText = Component.m_237115_((String)titleKey).getString();
                    int expCost = Integer.parseInt(node.getState());
                    int playerExp = this.getTotalExperience();
                    String costColor = playerExp >= expCost ? "\u00a7a" : "\u00a7c";
                    String costText = Component.m_237110_((String)"wheel.hundred_years_war.cost", (Object[])new Object[]{expCost}).getString();
                    label = Component.m_237113_((String)(baseText + "\n" + costColor + costText + "\u00a7r"));
                } else if (node.isDynamic() && node.getState() != null) {
                    String stateKey = titleKey + "." + node.getState();
                    label = Component.m_237115_((String)stateKey);
                } else {
                    label = Component.m_237115_((String)node.getTitleKey());
                }
                CommandWheelNode finalNode = node;
                TrapezoidButton btn = new TrapezoidButton(cx, cy, 40.0f, 120.0f, a0, a1, (Component)label, () -> {
                    finalNode.executeAction();
                    String nodeTitleKey = finalNode.getTitleKey();
                    boolean isFormationMode = "wheel.hundred_years_war.formation_mode".equals(nodeTitleKey);
                    boolean isFormationSelection = "wheel.hundred_years_war.formation".equals(nodeTitleKey);
                    boolean isFollow = "wheel.hundred_years_war.follow".equals(nodeTitleKey);
                    boolean isBack = "wheel.hundred_years_war.back".equals(nodeTitleKey);
                    boolean isFormationOption = nodeTitleKey.startsWith("wheel.hundred_years_war.formation.");
                    boolean isCreateSquad = "wheel.hundred_years_war.create_squad".equals(nodeTitleKey);
                    boolean isSelectSquad = "wheel.hundred_years_war.select_squad".equals(nodeTitleKey);
                    boolean isRecruitmentConfig = "wheel.hundred_years_war.recruitment_config".equals(nodeTitleKey);
                    boolean isRecruitmentCategory = nodeTitleKey.startsWith("recruitment.hundred_years_war.category.");
                    boolean isRecruitmentUnit = nodeTitleKey.startsWith("recruitment.hundred_years_war.unit.");
                    boolean isLoading = "wheel.hundred_years_war.loading".equals(nodeTitleKey);
                    if (!isFollow) {
                        if (isFormationMode || isFormationSelection || isBack || isFormationOption || isCreateSquad || isSelectSquad || isRecruitmentConfig || isRecruitmentCategory || isRecruitmentUnit || isLoading) {
                            this.refreshUI();
                        } else if (!finalNode.hasChildren() || finalNode.getAction() == null) {
                            this.close();
                        }
                    }
                });
                this.m_142416_((GuiEventListener)btn);
                this.buttons.add(btn);
                continue;
            }
            TrapezoidButton emptyBtn = new TrapezoidButton(cx, cy, 40.0f, 120.0f, a0, a1, (Component)Component.m_237119_(), () -> {});
            emptyBtn.m_93650_(0.3f);
            this.m_142416_((GuiEventListener)emptyBtn);
            this.buttons.add(emptyBtn);
        }
        if (totalPages > 1) {
            CustomButton prevPageButton = new CustomButton(cx - 15 - 15, (int)((float)cy + 15.0f - 5.0f), 15, 10, (Component)Component.m_237113_((String)"<"), button -> {
                --this.currentPage;
                if (this.currentPage < 0) {
                    this.currentPage = totalPages - 1;
                }
                this.refreshUI();
            });
            this.m_142416_(prevPageButton);
            CustomButton nextPageButton = new CustomButton(cx + 15, (int)((float)cy + 15.0f - 5.0f), 15, 10, (Component)Component.m_237113_((String)">"), button -> {
                ++this.currentPage;
                if (this.currentPage >= totalPages) {
                    this.currentPage = 0;
                }
                this.refreshUI();
            });
            this.m_142416_(nextPageButton);
        }
        if ((attackNode = this.tree.getAttackNode()) != null && attackNode.getState() != null) {
            this.lastAttackState = attackNode.getState();
        }
    }

    public void refreshUI() {
        this.m_7856_();
    }

    public void m_86600_() {
        String currentState;
        super.m_86600_();
        this.tree.updateNodesOnTick();
        CommandWheelNode attackNode = this.tree.getAttackNode();
        if (attackNode != null && attackNode.isDynamic() && (currentState = attackNode.getState()) != null && !currentState.equals(this.lastAttackState)) {
            this.lastAttackState = currentState;
            this.refreshUI();
        }
    }

    private void close() {
        this.f_96541_.m_91152_(null);
        CommandWheelHandler.getInstance().closeCommandWheel();
    }

    public boolean m_6050_(double dMouseX, double dMouseY, double delta) {
        int totalPages = this.tree.getTotalPages(8);
        if (totalPages > 1) {
            if (delta > 0.0) {
                --this.currentPage;
                if (this.currentPage < 0) {
                    this.currentPage = totalPages - 1;
                }
            } else if (delta < 0.0) {
                ++this.currentPage;
                if (this.currentPage >= totalPages) {
                    this.currentPage = 0;
                }
            }
            this.refreshUI();
            return true;
        }
        return super.m_6050_(dMouseX, dMouseY, delta);
    }

    public CommandWheelTree getCommandWheelTree() {
        return this.tree;
    }

    private int getTotalExperience() {
        if (this.f_96541_.f_91074_ == null) {
            return 0;
        }
        int currentExp = (int)(this.f_96541_.f_91074_.f_36080_ * (float)this.f_96541_.f_91074_.m_36323_()) + this.getTotalExperienceForLevel(this.f_96541_.f_91074_.f_36078_);
        return currentExp;
    }

    private int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private boolean isInRecruitmentLevelSelection() {
        CommandWheelNode currentNode = this.tree.getCurrentNode();
        if (currentNode == null || currentNode.getChildren().isEmpty()) {
            return false;
        }
        boolean hasLevelNodes = false;
        for (CommandWheelNode child : currentNode.getChildren()) {
            String titleKey = child.getTitleKey();
            if (titleKey.startsWith("army.hundred_years_war.")) {
                hasLevelNodes = true;
                continue;
            }
            if ("wheel.hundred_years_war.back".equals(titleKey)) continue;
            return false;
        }
        return hasLevelNodes;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int totalPages;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.f_96541_.f_91074_ != null && CommandWheelHandler.getInstance().isWheelOpen()) {
            int playerExp = this.getTotalExperience();
            String expText = Component.m_237110_((String)"wheel.hundred_years_war.player_exp", (Object[])new Object[]{playerExp}).getString();
            String[] lines = expText.split("\\n");
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int lineHeight = 9;
            int totalHeight = lines.length * lineHeight;
            int startY = this.f_96544_ / 2 - 15 - totalHeight / 2;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.matches(".*\\d+.*")) {
                    String textPart = line.replaceAll("\\d+", "").trim();
                    String numberPart = line.replaceAll("\\D+", "");
                    int textWidth = this.f_96541_.f_91062_.m_92895_(textPart);
                    int numberWidth = this.f_96541_.f_91062_.m_92895_("\u00a7e" + numberPart + "\u00a7r");
                    int totalWidth = textWidth + numberWidth;
                    int startX = this.f_96543_ / 2 - totalWidth / 2;
                    int textY = startY + i * lineHeight;
                    guiGraphics.m_280488_(this.f_96541_.f_91062_, textPart, startX, textY, 0xFFFFFF);
                    guiGraphics.m_280488_(this.f_96541_.f_91062_, "\u00a7e" + numberPart + "\u00a7r", startX + textWidth, textY, 0xFFFFFF);
                    continue;
                }
                int textWidth = this.f_96541_.f_91062_.m_92895_(line);
                int textX = this.f_96543_ / 2 - textWidth / 2;
                int textY = startY + i * lineHeight;
                guiGraphics.m_280488_(this.f_96541_.f_91062_, line, textX, textY, 0xFFFFFF);
            }
        }
        if ((totalPages = this.tree.getTotalPages(8)) > 1) {
            String pageText = this.currentPage + 1 + " / " + totalPages;
            int textWidth = this.f_96541_.f_91062_.m_92895_(pageText);
            int textX = this.f_96543_ / 2 - textWidth / 2 + 0;
            int n = this.f_96544_ / 2 + 15;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int textY = n - 9 / 2;
            guiGraphics.m_280488_(this.f_96541_.f_91062_, pageText, textX, textY, 0xFFFFFF);
        }
    }
}

