/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

public class CommandStaffInfoHandler {
    private static CommandStaffInfoHandler instance;
    private static final int PADDING = 5;
    private static final int ITEM_HEIGHT = 12;
    private static final float FONT_SCALE = 0.8f;

    private CommandStaffInfoHandler() {
    }

    public static CommandStaffInfoHandler getInstance() {
        if (instance == null) {
            instance = new CommandStaffInfoHandler();
        }
        return instance;
    }

    private Component getLeftClickInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.left_click");
    }

    private Component getRightClickShortInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.right_click_short");
    }

    private Component getRightClickLongInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.right_click_long");
    }

    private Component getShiftRightClickShortInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.shift_right_click_short");
    }

    private Component getShiftRightClickLongInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.shift_right_click_long");
    }

    private Component getMiddleClickInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.middle_click");
    }

    private Component getLookDownRightClickInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.command_staff.look_down_right_click");
    }

    private void drawScaledString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(0.8f, 0.8f, 1.0f);
        guiGraphics.m_280430_(font, text, 0, 0, color);
        poseStack.m_85849_();
    }

    private int getScaledWidth(Font font, Component text) {
        return (int)((float)font.m_92852_((FormattedText)text) * 0.8f);
    }

    public boolean isHoldingCommandStaff() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return false;
        }
        ItemStack mainHandItem = minecraft.f_91074_.m_21205_();
        return !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof CommandStaffItem;
    }

    public void renderCommandStaffInfo(GuiGraphics guiGraphics) {
        if (!this.isHoldingCommandStaff()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91062_;
        float scaledItemHeight = 9.6f;
        int listHeight = (int)(7.0f * scaledItemHeight) + 10;
        int startY = screenHeight - listHeight - 5;
        Component leftClickText = this.getLeftClickInfo();
        int leftClickY = startY + 5;
        this.drawScaledString(guiGraphics, font, leftClickText, screenWidth - 5 - this.getScaledWidth(font, leftClickText), leftClickY, 0xFFFFFF);
        Component rightClickShortText = this.getRightClickShortInfo();
        int rightClickShortY = leftClickY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, rightClickShortText, screenWidth - 5 - this.getScaledWidth(font, rightClickShortText), rightClickShortY, 0xFFFFFF);
        Component rightClickLongText = this.getRightClickLongInfo();
        int rightClickLongY = rightClickShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, rightClickLongText, screenWidth - 5 - this.getScaledWidth(font, rightClickLongText), rightClickLongY, 0xFFFFFF);
        Component shiftRightClickShortText = this.getShiftRightClickShortInfo();
        int shiftRightClickShortY = rightClickLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, shiftRightClickShortText, screenWidth - 5 - this.getScaledWidth(font, shiftRightClickShortText), shiftRightClickShortY, 0xFFFFFF);
        Component shiftRightClickLongText = this.getShiftRightClickLongInfo();
        int shiftRightClickLongY = shiftRightClickShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, shiftRightClickLongText, screenWidth - 5 - this.getScaledWidth(font, shiftRightClickLongText), shiftRightClickLongY, 0xFFFFFF);
        Component middleClickText = this.getMiddleClickInfo();
        int middleClickY = shiftRightClickLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, middleClickText, screenWidth - 5 - this.getScaledWidth(font, middleClickText), middleClickY, 0xFFFFFF);
        Component lookDownRightClickText = this.getLookDownRightClickInfo();
        int lookDownRightClickY = middleClickY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, lookDownRightClickText, screenWidth - 5 - this.getScaledWidth(font, lookDownRightClickText), lookDownRightClickY, 0xFFFFFF);
    }
}

