/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Mixin(value={EntityRenderDispatcher.class})
public class CommandStaffEntityRenderMixin {
    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.BEFORE)})
    private <E extends Entity> void onRender(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        Entity attackTarget;
        if (Freecam.isEnabled()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || entity == null || !entity.m_6084_()) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41619_() || !(mainHandItem.m_41720_() instanceof CommandStaffItem)) {
            return;
        }
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        handler.updateCurrentCommandStaff((Player)player);
        if (handler.isEntityInTeam(entity)) {
            this.renderTeamEntityBox(entity, poseStack, multiBufferSource, x, y, z);
        }
        if ((attackTarget = handler.getAttackTargetEntity()) != null && entity.equals((Object)attackTarget)) {
            this.renderAttackTargetBox(entity, poseStack, multiBufferSource, x, y, z);
        }
    }

    @Unique
    private void renderTeamEntityBox(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        float b;
        float g;
        float r;
        AABB box = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        double xOffset = 0.2;
        double zOffset = 0.2;
        if (entity instanceof SiegeUnit) {
            xOffset = 2.0;
            zOffset = 2.0;
        }
        double minX = box.f_82288_ - xOffset;
        double minY = box.f_82289_ + 0.2;
        double minZ = box.f_82290_ - zOffset;
        double maxX = box.f_82291_ + xOffset;
        double maxY = box.f_82289_ + 0.2;
        double maxZ = box.f_82293_ + zOffset;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
        ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
        RelationSystem.RelationType relationType = relationHelper.getRelationWithPlayer(entity);
        if (relationType == RelationSystem.RelationType.CONTROL) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else if (relationType == RelationSystem.RelationType.HOSTILE) {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 0.0f;
        }
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
    }

    @Unique
    private void renderAttackTargetBox(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        AABB box = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        double xOffset = 0.25;
        double zOffset = 0.25;
        if (entity instanceof SiegeUnit) {
            xOffset = 2.4;
            zOffset = 2.4;
        }
        double minX = box.f_82288_ - xOffset;
        double minY = box.f_82289_ + 0.2;
        double minZ = box.f_82290_ - zOffset;
        double maxX = box.f_82291_ + xOffset;
        double maxY = box.f_82289_ + 0.2;
        double maxZ = box.f_82293_ + zOffset;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
    }
}

