/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.mixins.HumanoidArmorLayerAccessor;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Pseudo
@Mixin(value={HumanoidArmorLayer.class})
public abstract class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Unique
    private T currentLivingEntity;
    @Unique
    private EquipmentSlot currentEquipmentSlot;

    public HumanoidArmorLayerMixin(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Unique
    private boolean isSkeletonEntity(LivingEntity entity) {
        return entity instanceof HywSkeletonEntity || entity instanceof HywSkeletonArcherEntity;
    }

    @Inject(method={"renderArmorPiece"}, at={@At(value="HEAD")})
    private void onRenderArmorPieceStart(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, CallbackInfo ci) {
        this.currentLivingEntity = livingEntity;
        this.currentEquipmentSlot = equipmentSlot;
        if (this.isSkeletonEntity((LivingEntity)livingEntity)) {
            boolean isHead;
            boolean isChest = equipmentSlot == EquipmentSlot.CHEST;
            boolean bl = isHead = equipmentSlot == EquipmentSlot.HEAD;
            if (isChest) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.04f, 0.0f);
                poseStack.m_85841_(0.85f, 0.7f, 0.85f);
            } else if (isHead) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                poseStack.m_85841_(0.9f, 0.9f, 0.9f);
            }
        }
    }

    @Inject(method={"renderArmorPiece"}, at={@At(value="RETURN")})
    private void onRenderArmorPieceEnd(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, CallbackInfo ci) {
        if (this.isSkeletonEntity((LivingEntity)livingEntity)) {
            boolean isHead;
            boolean isChest = equipmentSlot == EquipmentSlot.CHEST;
            boolean bl = isHead = equipmentSlot == EquipmentSlot.HEAD;
            if (isChest || isHead) {
                poseStack.m_85849_();
            }
        }
    }

    @Redirect(method={"renderArmorPiece"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;renderModel(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/ArmorItem;Lnet/minecraft/client/model/Model;ZFFFLnet/minecraft/resources/ResourceLocation;)V"))
    private void redirectRenderModel(HumanoidArmorLayer instance, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorItem armorItem, Model model, boolean bl, float f, float g, float h, ResourceLocation armorResource) {
        if (HotKeyManager.getTeamColorMode() && this.currentLivingEntity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)this.currentLivingEntity;
            ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
            RelationSystem.RelationType relationType = relationHelper.getRelationWithPlayer((Entity)combatEntity);
            if (relationType == RelationSystem.RelationType.CONTROL) {
                f = 0.7f;
                g = 1.0f;
                h = 0.7f;
            } else if (relationType != RelationSystem.RelationType.HOSTILE) {
                f = 1.0f;
                g = 1.0f;
                h = 0.7f;
            } else {
                f = 1.0f;
                g = 0.7f;
                h = 0.7f;
            }
        }
        ((HumanoidArmorLayerAccessor)instance).invokeRenderModel(poseStack, multiBufferSource, i, armorItem, model, bl, f, g, h, armorResource);
    }

    @Redirect(method={"renderArmorPiece"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;setPartVisibility(Lnet/minecraft/client/model/HumanoidModel;Lnet/minecraft/world/entity/EquipmentSlot;)V"))
    private void redirectSetPartVisibility(HumanoidArmorLayer instance, HumanoidModel humanoidModel, EquipmentSlot equipmentSlot) {
        ((HumanoidArmorLayerAccessor)instance).invokeSetPartVisibility(humanoidModel, equipmentSlot);
        if (this.isSkeletonEntity((LivingEntity)this.currentLivingEntity) && equipmentSlot == EquipmentSlot.CHEST) {
            humanoidModel.f_102811_.f_104207_ = false;
            humanoidModel.f_102812_.f_104207_ = false;
        }
    }
}

