/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    private boolean originalRidingState = false;
    private boolean ridingStateModified = false;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void onSetupAnimStart(LivingEntity livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        HumanoidModel self = (HumanoidModel)this;
        this.originalRidingState = self.f_102609_;
        this.ridingStateModified = false;
        if (this.shouldUseStandingPose(livingEntity)) {
            self.f_102609_ = false;
            this.ridingStateModified = true;
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")})
    private void onSetupAnimEnd(LivingEntity livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (this.ridingStateModified) {
            ((HumanoidModel)this).f_102609_ = this.originalRidingState;
        }
    }

    private boolean shouldUseStandingPose(LivingEntity livingEntity) {
        Entity vehicle = livingEntity.m_20202_();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            MultiSeatVehicle.SeatPose pose = multiSeatVehicle.getSeatForEntity((Entity)livingEntity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
            return pose == MultiSeatVehicle.SeatPose.STANDING;
        }
        return false;
    }
}

