/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.utils.ChargeWeaponHelper;
import ydmsama.hundred_years_war.main.entity.entities.PriestEntity;
import ydmsama.hundred_years_war.main.entity.entities.SpearManEntity;

@Mixin(value={ItemInHandLayer.class})
public class ItemInHandLayerMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Shadow
    private ItemInHandRenderer f_234844_;

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArmWithItem(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext itemDisplayContext, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        ItemStack mainHandItem = livingEntity.m_21205_();
        if (ChargeWeaponHelper.isChargeWeapon(mainHandItem) && itemStack == mainHandItem) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRender(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        SpearManEntity spearManEntity;
        if (entity instanceof SpearManEntity && (spearManEntity = (SpearManEntity)entity).shouldHoldWeaponVertically()) {
            boolean mainHandRight = spearManEntity.m_5737_() == HumanoidArm.RIGHT;
            ItemStack offhandStack = mainHandRight ? spearManEntity.m_21206_() : spearManEntity.m_21205_();
            ItemStack mainHandStack = mainHandRight ? spearManEntity.m_21205_() : spearManEntity.m_21206_();
            poseStack.m_85836_();
            this.renderItemInHandForSpearman(spearManEntity, mainHandStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferSource, packedLight);
            this.renderItemInHandForSpearman(spearManEntity, offhandStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
            ci.cancel();
        } else if (entity instanceof PriestEntity) {
            PriestEntity priestEntity = (PriestEntity)entity;
            boolean mainHandRight = priestEntity.m_5737_() == HumanoidArm.RIGHT;
            ItemStack offhandStack = mainHandRight ? priestEntity.m_21206_() : priestEntity.m_21205_();
            ItemStack mainHandStack = mainHandRight ? priestEntity.m_21205_() : priestEntity.m_21206_();
            poseStack.m_85836_();
            this.renderItemInHandForPriest(priestEntity, mainHandStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferSource, packedLight);
            this.renderItemInHandForPriest(priestEntity, offhandStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
            ci.cancel();
        }
    }

    private void renderItemInHandForSpearman(SpearManEntity entity, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!stack.m_41619_()) {
            boolean isPikeOrLance;
            poseStack.m_85836_();
            ((ArmedModel)((ItemInHandLayer)this).m_117386_()).m_6002_(arm, poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean leftHand = arm == HumanoidArm.LEFT;
            poseStack.m_252880_((float)(leftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            boolean bl = isPikeOrLance = stack.m_41720_().toString().contains("pike") || stack.m_41720_().toString().contains("lance");
            if (entity.shouldHoldWeaponVertically() && arm == HumanoidArm.RIGHT && isPikeOrLance) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
                poseStack.m_252880_(0.0f, 0.5f, 0.0f);
            }
            this.f_234844_.m_269530_((LivingEntity)entity, stack, displayContext, leftHand, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    private void renderItemInHandForPriest(PriestEntity entity, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            ((ArmedModel)((ItemInHandLayer)this).m_117386_()).m_6002_(arm, poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean leftHand = arm == HumanoidArm.LEFT;
            poseStack.m_252880_((float)(leftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            boolean isPriestCane = stack.m_41720_().toString().contains("priest_cane");
            if (leftHand && isPriestCane) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
                poseStack.m_252880_(0.0f, 0.2f, -0.05f);
            }
            this.f_234844_.m_269530_((LivingEntity)entity, stack, displayContext, leftHand, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }
}

