/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.models.PriestModel;
import ydmsama.hundred_years_war.client.renderer.layers.FactionTintLayer;
import ydmsama.hundred_years_war.main.entity.entities.PriestEntity;

public class PriestRenderer
extends HumanoidMobRenderer<PriestEntity, PriestModel<PriestEntity>> {
    private final PriestModel<PriestEntity> normalModel;
    private final PriestModel<PriestEntity> slimModel;
    private static final Map<Integer, String> GENDER_SUFFIX_CACHE = new ConcurrentHashMap<Integer, String>();

    public PriestRenderer(EntityRendererProvider.Context context) {
        super(context, new PriestModel(context.m_174023_(PriestModel.LAYER_LOCATION), false), 0.5f);
        this.normalModel = new PriestModel(context.m_174023_(PriestModel.LAYER_LOCATION), false);
        this.slimModel = new PriestModel(context.m_174023_(PriestModel.SLIM_LAYER_LOCATION), true);
        this.m_115326_(new FactionTintLayer(this));
        this.preloadCommonSkinGenders();
    }

    private void preloadCommonSkinGenders() {
        for (int i = 1; i <= 6; ++i) {
            this.getGenderSuffixFromSkinIndex(i);
        }
    }

    public static void clearGenderCache() {
        GENDER_SUFFIX_CACHE.clear();
    }

    @NotNull
    public ResourceLocation getTextureLocation(PriestEntity entity) {
        int skinIndex = entity.getCurrentSkinIndex();
        String genderSuffix = this.getGenderSuffixFromSkinIndex(skinIndex);
        return new ResourceLocation("hundred_years_war", "textures/entity/priest/priest" + skinIndex + genderSuffix + ".png");
    }

    public void render(PriestEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean useSlim = this.shouldUseSlimModel(entity.getCurrentSkinIndex());
        this.f_115290_ = useSlim ? this.slimModel : this.normalModel;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private String getGenderSuffixFromSkinIndex(int skinIndex) {
        return GENDER_SUFFIX_CACHE.computeIfAbsent(skinIndex, this::detectGenderSuffixFromFile);
    }

    private String detectGenderSuffixFromFile(int skinIndex) {
        try {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            ResourceLocation femaleTexture = new ResourceLocation("hundred_years_war", "textures/entity/priest/priest" + skinIndex + "f.png");
            if (resourceManager.m_213713_(femaleTexture).isPresent()) {
                return "f";
            }
            ResourceLocation maleTexture = new ResourceLocation("hundred_years_war", "textures/entity/priest/priest" + skinIndex + "m.png");
            if (resourceManager.m_213713_(maleTexture).isPresent()) {
                return "m";
            }
            return "m";
        }
        catch (Exception e) {
            return "m";
        }
    }

    private boolean shouldUseSlimModel(int skinIndex) {
        String genderSuffix = this.getGenderSuffixFromSkinIndex(skinIndex);
        return "f".equals(genderSuffix);
    }
}

