/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

@Mod.EventBusSubscriber(modid="hundred_years_war", value={Dist.CLIENT})
public class TransportTargetRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            float tickDelta = event.getPartialTick();
            TransportTargetRenderer.render(poseStack, (MultiBufferSource)bufferSource, tickDelta);
        }
    }

    private static void render(PoseStack poseStack, MultiBufferSource bufferSource, float tickDelta) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        ItemStack mainHand = minecraft.f_91074_.m_21205_();
        ItemStack offHand = minecraft.f_91074_.m_21206_();
        ItemStack commandItem = null;
        if (mainHand.m_41720_() instanceof TransportOrderItem) {
            commandItem = mainHand;
        } else if (offHand.m_41720_() instanceof TransportOrderItem) {
            commandItem = offHand;
        }
        if (commandItem == null) {
            return;
        }
        Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource textBufferSource = minecraft.m_91269_().m_110104_();
        BlockPos boundPos = TransportOrderItem.getBoundWorkstation(commandItem);
        if (boundPos != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            AABB boundBox = new AABB(boundPos).m_82400_(0.002);
            VertexConsumer boundConsumer = bufferSource.m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)boundConsumer, (double)boundBox.f_82288_, (double)boundBox.f_82289_, (double)boundBox.f_82290_, (double)boundBox.f_82291_, (double)boundBox.f_82292_, (double)boundBox.f_82293_, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            poseStack.m_85849_();
            TransportTargetRenderer.renderNumber(poseStack, (MultiBufferSource)textBufferSource, boundPos, 0, cameraPos);
        }
        List<BlockPos> positions = TransportOrderItem.getPositionsForRender(commandItem);
        int index = 1;
        for (BlockPos pos : positions) {
            TransportTargetRenderer.renderBlockOutline(poseStack, bufferSource, pos, cameraPos);
            TransportTargetRenderer.renderNumber(poseStack, (MultiBufferSource)textBufferSource, pos, index, cameraPos);
            ++index;
        }
        textBufferSource.m_109911_();
    }

    private static void renderBlockOutline(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, Vec3 cameraPos) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        AABB box = new AABB(pos).m_82400_(0.002);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderNumber(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, int number, Vec3 cameraPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        String text = String.valueOf(number);
        poseStack.m_85836_();
        double x = (double)pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)pos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double z = (double)pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        poseStack.m_85837_(x, y, z);
        poseStack.m_252781_(minecraft.f_91063_.m_109153_().m_253121_());
        float scale = 0.05f;
        poseStack.m_85841_(-scale, -scale, scale);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float textX = (float)(-font.m_92895_(text)) / 2.0f;
        int light = 0xF000F0;
        font.m_271703_(text, textX, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, 0x40000000, light);
        font.m_271703_(text, textX, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85849_();
    }
}

